/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAndNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAsDequeNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAsMapNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAsSetNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAsStringNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAvgNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayDevNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayEmptyNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayExtractNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayGroupByNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayGroupNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayIndexOfByNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayIndexOfNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayIndexOfOrderedByNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayIndexOfOrderedNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayKeepOneForEachByNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayKeepOneForEachNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayLastIndexOfByNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayLastIndexOfNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayMaxNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayMedNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayMedUnorderedNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayMinNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayOrNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayOrderAscendingByNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayOrderAscendingNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayOrderDescendingByNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayOrderDescendingNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayPeekNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayProdNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayReverseNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayShuffleNode;
import de.unika.ipd.grgen.ast.expr.array.ArraySizeNode;
import de.unika.ipd.grgen.ast.expr.array.ArraySubarrayNode;
import de.unika.ipd.grgen.ast.expr.array.ArraySumNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayVarNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeAsArrayNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeAsSetNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeEmptyNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeIndexOfNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeLastIndexOfNode;
import de.unika.ipd.grgen.ast.expr.deque.DequePeekNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeSizeNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeSubdequeNode;
import de.unika.ipd.grgen.ast.expr.invocation.ExternalFunctionMethodInvocationExprNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionMethodInvocationExprNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionOrBuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.invocation.UntypedFunctionMethodInvocationExprNode;
import de.unika.ipd.grgen.ast.expr.map.MapAsArrayNode;
import de.unika.ipd.grgen.ast.expr.map.MapDomainNode;
import de.unika.ipd.grgen.ast.expr.map.MapEmptyNode;
import de.unika.ipd.grgen.ast.expr.map.MapPeekNode;
import de.unika.ipd.grgen.ast.expr.map.MapRangeNode;
import de.unika.ipd.grgen.ast.expr.map.MapSizeNode;
import de.unika.ipd.grgen.ast.expr.set.SetAsArrayNode;
import de.unika.ipd.grgen.ast.expr.set.SetEmptyNode;
import de.unika.ipd.grgen.ast.expr.set.SetMaxNode;
import de.unika.ipd.grgen.ast.expr.set.SetMinNode;
import de.unika.ipd.grgen.ast.expr.set.SetPeekNode;
import de.unika.ipd.grgen.ast.expr.set.SetSizeNode;
import de.unika.ipd.grgen.ast.expr.string.StringAsArrayNode;
import de.unika.ipd.grgen.ast.expr.string.StringEndsWithNode;
import de.unika.ipd.grgen.ast.expr.string.StringIndexOfNode;
import de.unika.ipd.grgen.ast.expr.string.StringLastIndexOfNode;
import de.unika.ipd.grgen.ast.expr.string.StringLengthNode;
import de.unika.ipd.grgen.ast.expr.string.StringReplaceNode;
import de.unika.ipd.grgen.ast.expr.string.StringStartsWithNode;
import de.unika.ipd.grgen.ast.expr.string.StringSubstringNode;
import de.unika.ipd.grgen.ast.expr.string.StringToLowerNode;
import de.unika.ipd.grgen.ast.expr.string.StringToUpperNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.UntypedExecVarTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ast.util.ResolvingEnvironment;
import de.unika.ipd.grgen.ir.IR;
import java.util.Collection;
import java.util.Vector;

public class FunctionMethodInvocationDecisionNode
extends FunctionInvocationBaseNode {
    static TypeNode methodTypeNode;
    private ExprNode targetExpr;
    private IdentNode methodIdent;
    private IdentNode attributeIdent;
    private FunctionOrBuiltinFunctionInvocationBaseNode result;

    public FunctionMethodInvocationDecisionNode(ExprNode exprNode, IdentNode identNode, CollectNode<ExprNode> collectNode, IdentNode identNode2) {
        super(identNode.getCoords(), collectNode);
        this.targetExpr = this.becomeParent(exprNode);
        this.methodIdent = this.becomeParent(identNode);
        this.attributeIdent = this.becomeParent(identNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.targetExpr);
        vector.add(this.arguments);
        if (this.isResolved()) {
            vector.add(this.result);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        vector.add("params");
        if (this.isResolved()) {
            vector.add("result");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (!this.targetExpr.resolve()) {
            return false;
        }
        String string = this.methodIdent.toString();
        TypeNode typeNode = this.targetExpr.getType();
        ResolvingEnvironment resolvingEnvironment = new ResolvingEnvironment(null, error, this.getCoords());
        if (typeNode == BasicTypeNode.stringType) {
            this.result = FunctionMethodInvocationDecisionNode.decideString(this.targetExpr, this.attributeIdent, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof MapTypeNode) {
            this.result = FunctionMethodInvocationDecisionNode.decideMap(this.targetExpr, this.attributeIdent, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof SetTypeNode) {
            this.result = FunctionMethodInvocationDecisionNode.decideSet(this.targetExpr, this.attributeIdent, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof ArrayTypeNode) {
            this.result = FunctionMethodInvocationDecisionNode.decideArray(this.targetExpr, this.attributeIdent, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof DequeTypeNode) {
            this.result = FunctionMethodInvocationDecisionNode.decideDeque(this.targetExpr, this.attributeIdent, string, this.arguments, resolvingEnvironment);
        } else if (typeNode instanceof InheritanceTypeNode && !(typeNode instanceof ExternalObjectTypeNode)) {
            if (this.targetExpr instanceof FunctionMethodInvocationDecisionNode) {
                this.reportError("Method call chains are not supported, assign to a temporary def variable and invoke the method on it.");
                return false;
            }
            this.result = new FunctionMethodInvocationExprNode(((IdentExprNode)this.targetExpr).getIdent(), this.methodIdent, this.arguments);
        } else if (typeNode instanceof ExternalObjectTypeNode) {
            this.result = new ExternalFunctionMethodInvocationExprNode(this.targetExpr, this.methodIdent, this.arguments);
        } else if (typeNode instanceof UntypedExecVarTypeNode) {
            this.result = new UntypedFunctionMethodInvocationExprNode(this.methodIdent.getCoords(), this.arguments);
        } else {
            this.reportError(typeNode.getTypeName() + " does not have any function methods.");
        }
        return this.result != null;
    }

    private static BuiltinFunctionInvocationBaseNode decideString(ExprNode exprNode, IdentNode identNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "length": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("string.length() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new StringLengthNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "toUpper": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("string.toUpper() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new StringToUpperNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "toLower": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("string.toLower() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new StringToLowerNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "substring": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("string.substring(startIndex, length) expects 2 arguments, or 1 if the length is omitted (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 2) {
                    return new StringSubstringNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
                }
                return new StringSubstringNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
            case "indexOf": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("string.indexOf(strToSearchFor) expects one argument, or a second startIndex argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new StringIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
                }
                return new StringIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
            }
            case "lastIndexOf": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("string.lastIndexOf(strToSearchFor) expects one argument, or a second startIndex argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new StringLastIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
                }
                return new StringLastIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
            }
            case "startsWith": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("string.startsWith(strToSearchFor) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new StringStartsWithNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
            case "endsWith": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("string.endsWith(strToSearchFor) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new StringEndsWithNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
            case "replace": {
                if (collectNode.size() != 3) {
                    resolvingEnvironment.reportError("string.replace(startIndex, length, replaceStr) expects 3 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new StringReplaceNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1), collectNode.get(2));
            }
            case "asArray": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("string.asArray(separator) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new StringAsArrayNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
        }
        resolvingEnvironment.reportError("string does not have a function method named " + string + ".");
        return null;
    }

    private static BuiltinFunctionInvocationBaseNode decideMap(ExprNode exprNode, IdentNode identNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "size": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("map<S,T>.size() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new MapSizeNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "empty": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("map<S,T>.empty() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new MapEmptyNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "domain": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("map<S,T>.domain() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new MapDomainNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "range": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("map<S,T>.range() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new MapRangeNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "asArray": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("map<int,T>.asArray() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new MapAsArrayNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "peek": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("map<S,T>.peek(number in iteration sequence) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new MapPeekNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
        }
        resolvingEnvironment.reportError("map<S,T> does not have a function method named " + string + ".");
        return null;
    }

    private static BuiltinFunctionInvocationBaseNode decideSet(ExprNode exprNode, IdentNode identNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "size": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("set<T>.size() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SetSizeNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "empty": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("set<T>.empty() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SetEmptyNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "peek": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("set<T>.peek(number in iteration sequence) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SetPeekNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
            case "min": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("set<T>.min() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SetMinNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "max": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("set<T>.max() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SetMaxNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "asArray": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("set<T>.asArray() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SetAsArrayNode(resolvingEnvironment.getCoords(), exprNode);
            }
        }
        resolvingEnvironment.reportError("set<T> does not have a function method named " + string + ".");
        return null;
    }

    private static BuiltinFunctionInvocationBaseNode decideArray(ExprNode exprNode, IdentNode identNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "size": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.size() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArraySizeNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "empty": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.empty() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayEmptyNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "peek": {
                if (collectNode.size() != 0 && collectNode.size() != 1) {
                    resolvingEnvironment.reportError("array<T>.peek(index) expects 1 argument; or 0 arguments, then returning the value from the end (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 0) {
                    return new ArrayPeekNode(resolvingEnvironment.getCoords(), exprNode);
                }
                return new ArrayPeekNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
            case "indexOf": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("array<T>.indexOf(valueToSearchFor) expects one argument, or a second startIndex argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new ArrayIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
                }
                return new ArrayIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
            }
            case "indexOfBy": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("array<T>.indexOfBy<attribute>(valueToSearchFor) expects one argument, or a second startIndex argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new ArrayIndexOfByNode(resolvingEnvironment.getCoords(), exprNode, identNode, collectNode.get(0));
                }
                return new ArrayIndexOfByNode(resolvingEnvironment.getCoords(), exprNode, identNode, collectNode.get(0), collectNode.get(1));
            }
            case "indexOfOrdered": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("array<T>.indexOfOrdered(valueToSearchFor) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayIndexOfOrderedNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
            case "indexOfOrderedBy": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("array<T>.indexOfOrderedBy<attribute>(valueToSearchFor) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayIndexOfOrderedByNode(resolvingEnvironment.getCoords(), exprNode, identNode, collectNode.get(0));
            }
            case "lastIndexOf": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("array<T>.lastIndexOf(valueToSearchFor) expects 1 argument, or a second startIndex argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new ArrayLastIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
                }
                return new ArrayLastIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
            }
            case "lastIndexOfBy": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("array<T>.lastIndexOfBy<attribute>(valueToSearchFor) expects one argument, or a second startIndex argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new ArrayLastIndexOfByNode(resolvingEnvironment.getCoords(), exprNode, identNode, collectNode.get(0));
                }
                return new ArrayLastIndexOfByNode(resolvingEnvironment.getCoords(), exprNode, identNode, collectNode.get(0), collectNode.get(1));
            }
            case "subarray": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("array<T>.subarray(startIndex, length) expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArraySubarrayNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
            }
            case "orderAscending": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.orderAscending() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayOrderAscendingNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "orderDescending": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.orderDescending() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayOrderDescendingNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "group": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.group() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayGroupNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "keepOneForEach": {
                if (identNode == null) {
                    if (collectNode.size() != 0) {
                        resolvingEnvironment.reportError("array<T>.keepOneForEach() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                        return null;
                    }
                    return new ArrayKeepOneForEachNode(resolvingEnvironment.getCoords(), exprNode);
                }
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.keepOneForEach<attribute>() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayKeepOneForEachByNode(resolvingEnvironment.getCoords(), exprNode, identNode);
            }
            case "orderAscendingBy": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.orderAscendingBy<attribute>() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayOrderAscendingByNode(resolvingEnvironment.getCoords(), exprNode, identNode);
            }
            case "orderDescendingBy": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.orderDescendingBy<attribute>() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayOrderDescendingByNode(resolvingEnvironment.getCoords(), exprNode, identNode);
            }
            case "groupBy": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.groupBy<attribute>() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayGroupByNode(resolvingEnvironment.getCoords(), exprNode, identNode);
            }
            case "reverse": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.reverse() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayReverseNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "shuffle": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.shuffle() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayShuffleNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "extract": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.extract<attribute>() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayExtractNode(resolvingEnvironment.getCoords(), exprNode, identNode);
            }
            case "asSet": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.asSet() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayAsSetNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "asDeque": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.asDeque() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayAsDequeNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "asMap": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.asMap() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayAsMapNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "asString": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("array<string>.asString(separator) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayAsStringNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
            case "sum": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.sum() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArraySumNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "prod": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.prod() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayProdNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "min": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.min() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayMinNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "max": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.max() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayMaxNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "avg": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.avg() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayAvgNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "med": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.med() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayMedNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "medUnordered": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.medUnordered() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayMedUnorderedNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "var": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.var() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayVarNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "dev": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.dev() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayDevNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "and": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.and() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayAndNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "or": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("array<T>.or() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArrayOrNode(resolvingEnvironment.getCoords(), exprNode);
            }
        }
        resolvingEnvironment.reportError("array<T> does not have a function method named " + string + ".");
        return null;
    }

    private static BuiltinFunctionInvocationBaseNode decideDeque(ExprNode exprNode, IdentNode identNode, String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "size": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("deque<T>.size() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new DequeSizeNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "empty": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("deque<T>.empty() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new DequeEmptyNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "peek": {
                if (collectNode.size() != 0 && collectNode.size() != 1) {
                    resolvingEnvironment.reportError("deque<T>.peek(index) expects 1 argument; or 0 arguments, then returning the value from the begin (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 0) {
                    return new DequePeekNode(resolvingEnvironment.getCoords(), exprNode);
                }
                return new DequePeekNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
            }
            case "indexOf": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("deque<T>.indexOf(valueToSearchFor) expects one argument, or a second startIndex argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new DequeIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
                }
                return new DequeIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
            }
            case "lastIndexOf": {
                if (collectNode.size() != 1 && collectNode.size() != 2) {
                    resolvingEnvironment.reportError("deque<T>.lastIndexOf(valueToSearchFor) expects one argument, or a second startIndex argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new DequeLastIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0));
                }
                return new DequeLastIndexOfNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
            }
            case "subdeque": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("deque<T>.subdeque(startIndex, length) expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new DequeSubdequeNode(resolvingEnvironment.getCoords(), exprNode, collectNode.get(0), collectNode.get(1));
            }
            case "asSet": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("deque<T>.asSet() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new DequeAsSetNode(resolvingEnvironment.getCoords(), exprNode);
            }
            case "asArray": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("deque<T>.asArray() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new DequeAsArrayNode(resolvingEnvironment.getCoords(), exprNode);
            }
        }
        resolvingEnvironment.reportError("deque<T> does not have a function method named " + string + ".");
        return null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.result.getType();
    }

    protected ExprNode getResult() {
        return this.result;
    }

    @Override
    protected IR constructIR() {
        return this.result.getIR();
    }

    static {
        FunctionMethodInvocationDecisionNode.setName(FunctionMethodInvocationDecisionNode.class, "function method invocation decision expression");
        methodTypeNode = new TypeNode(){

            public Collection<BaseNode> getChildren() {
                Vector<BaseNode> vector = new Vector<BaseNode>();
                return vector;
            }

            @Override
            public Collection<String> getChildrenNames() {
                Vector<String> vector = new Vector<String>();
                return vector;
            }
        };
    }
}

