/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.CopyExprNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.graph.AdjacentNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.BoundedReachableEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.BoundedReachableNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.BoundedReachableNodeWithRemainingDepthExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CanonizeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CountAdjacentNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CountBoundedReachableEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CountBoundedReachableNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CountEdgesExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CountIncidentEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CountNodesExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CountReachableEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.CountReachableNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.DefinedSubgraphExprNode;
import de.unika.ipd.grgen.ast.expr.graph.EdgeByNameExprNode;
import de.unika.ipd.grgen.ast.expr.graph.EdgeByUniqueExprNode;
import de.unika.ipd.grgen.ast.expr.graph.EdgesExprNode;
import de.unika.ipd.grgen.ast.expr.graph.EmptyExprNode;
import de.unika.ipd.grgen.ast.expr.graph.EqualsAnyExprNode;
import de.unika.ipd.grgen.ast.expr.graph.GetEquivalentExprNode;
import de.unika.ipd.grgen.ast.expr.graph.GraphofExprNode;
import de.unika.ipd.grgen.ast.expr.graph.IncidentEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.InducedSubgraphExprNode;
import de.unika.ipd.grgen.ast.expr.graph.IsAdjacentNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.IsBoundedReachableEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.IsBoundedReachableNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.IsIncidentEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.IsReachableEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.IsReachableNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.NodeByNameExprNode;
import de.unika.ipd.grgen.ast.expr.graph.NodeByUniqueExprNode;
import de.unika.ipd.grgen.ast.expr.graph.NodesExprNode;
import de.unika.ipd.grgen.ast.expr.graph.OppositeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.ReachableEdgeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.ReachableNodeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.SizeExprNode;
import de.unika.ipd.grgen.ast.expr.graph.SourceExprNode;
import de.unika.ipd.grgen.ast.expr.graph.TargetExprNode;
import de.unika.ipd.grgen.ast.expr.graph.UniqueofExprNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.procenv.RandomNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.FunctionTypeNode;
import de.unika.ipd.grgen.ast.util.ResolvingEnvironment;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.ParserEnvironment;
import de.unika.ipd.grgen.util.Direction;
import java.util.Collection;
import java.util.Vector;

public class FunctionInvocationDecisionNode
extends FunctionInvocationBaseNode {
    static TypeNode functionTypeNode;
    public IdentNode functionIdent;
    private BuiltinFunctionInvocationBaseNode result;
    ParserEnvironment env;

    public FunctionInvocationDecisionNode(IdentNode identNode, CollectNode<ExprNode> collectNode, ParserEnvironment parserEnvironment) {
        super(identNode.getCoords(), collectNode);
        this.functionIdent = this.becomeParent(identNode);
        this.env = parserEnvironment;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.arguments);
        if (this.isResolved()) {
            vector.add(this.result);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("params");
        if (this.isResolved()) {
            vector.add("result");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        ResolvingEnvironment resolvingEnvironment = new ResolvingEnvironment(this.env, error, this.getCoords());
        this.result = FunctionInvocationDecisionNode.decide(this.functionIdent.toString(), this.arguments, resolvingEnvironment);
        return this.result != null;
    }

    private static BuiltinFunctionInvocationBaseNode decide(String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "random": {
                if (collectNode.size() == 1) {
                    return new RandomNode(resolvingEnvironment.getCoords(), collectNode.get(0));
                }
                if (collectNode.size() == 0) {
                    return new RandomNode(resolvingEnvironment.getCoords(), null);
                }
                resolvingEnvironment.reportError("random() expects 1 or 0 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "nodes": {
                if (collectNode.size() > 1) {
                    resolvingEnvironment.reportError("nodes() expects 1 or 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new NodesExprNode(resolvingEnvironment.getCoords(), collectNode.size() == 1 ? collectNode.get(0) : new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
            }
            case "edges": {
                if (collectNode.size() > 1) {
                    resolvingEnvironment.reportError("edges() expects 1 or 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new EdgesExprNode(resolvingEnvironment.getCoords(), collectNode.size() == 1 ? collectNode.get(0) : new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()));
            }
            case "countNodes": {
                if (collectNode.size() > 1) {
                    resolvingEnvironment.reportError("countNodes() expects 1 or 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new CountNodesExprNode(resolvingEnvironment.getCoords(), collectNode.size() == 1 ? collectNode.get(0) : new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
            }
            case "countEdges": {
                if (collectNode.size() > 1) {
                    resolvingEnvironment.reportError("countEdges() expects 1 or 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new CountEdgesExprNode(resolvingEnvironment.getCoords(), collectNode.size() == 1 ? collectNode.get(0) : new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()));
            }
            case "empty": {
                if (collectNode.size() > 0) {
                    resolvingEnvironment.reportError("empty() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new EmptyExprNode(resolvingEnvironment.getCoords());
            }
            case "size": {
                if (collectNode.size() > 0) {
                    resolvingEnvironment.reportError("size() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SizeExprNode(resolvingEnvironment.getCoords());
            }
            case "source": {
                if (collectNode.size() == 1) {
                    return new SourceExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), resolvingEnvironment.getParserEnvironment().getNodeRoot());
                }
                resolvingEnvironment.reportError(string + "() expects 1 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "target": {
                if (collectNode.size() == 1) {
                    return new TargetExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), resolvingEnvironment.getParserEnvironment().getNodeRoot());
                }
                resolvingEnvironment.reportError(string + "() expects 1 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "opposite": {
                if (collectNode.size() == 2) {
                    return new OppositeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), resolvingEnvironment.getParserEnvironment().getNodeRoot());
                }
                resolvingEnvironment.reportError(string + "() expects 2 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "nodeByName": {
                if (collectNode.size() >= 1 && collectNode.size() <= 2) {
                    return new NodeByNameExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.size() == 2 ? collectNode.get(1) : new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                resolvingEnvironment.reportError(string + "() expects 1 or 2 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "edgeByName": {
                if (collectNode.size() >= 1 && collectNode.size() <= 2) {
                    return new EdgeByNameExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.size() == 2 ? collectNode.get(1) : new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()));
                }
                resolvingEnvironment.reportError(string + "() expects 1 or 2 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "nodeByUnique": {
                if (collectNode.size() >= 1 && collectNode.size() <= 2) {
                    return new NodeByUniqueExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.size() == 2 ? collectNode.get(1) : new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                resolvingEnvironment.reportError(string + "() expects 1 or 2 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "edgeByUnique": {
                if (collectNode.size() >= 1 && collectNode.size() <= 2) {
                    return new EdgeByUniqueExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.size() == 2 ? collectNode.get(1) : new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()));
                }
                resolvingEnvironment.reportError(string + "() expects 1 or 2 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "incoming": 
            case "outgoing": 
            case "incident": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 1) {
                    return new IncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 2) {
                    return new IncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new IncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1-3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "adjacentIncoming": 
            case "adjacentOutgoing": 
            case "adjacent": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 1) {
                    return new AdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 2) {
                    return new AdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new AdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1-3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "countIncoming": 
            case "countOutgoing": 
            case "countIncident": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 1) {
                    return new CountIncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 2) {
                    return new CountIncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new CountIncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1-3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "countAdjacentIncoming": 
            case "countAdjacentOutgoing": 
            case "countAdjacent": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 1) {
                    return new CountAdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 2) {
                    return new CountAdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new CountAdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1-3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "isIncoming": 
            case "isOutgoing": 
            case "isIncident": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new IsIncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new IsIncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new IsIncidentEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "isAdjacentIncoming": 
            case "isAdjacentOutgoing": 
            case "isAdjacent": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new IsAdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new IsAdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new IsAdjacentNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "reachableEdgesIncoming": 
            case "reachableEdgesOutgoing": 
            case "reachableEdges": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 1) {
                    return new ReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 2) {
                    return new ReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new ReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1-3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "reachableIncoming": 
            case "reachableOutgoing": 
            case "reachable": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 1) {
                    return new ReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 2) {
                    return new ReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new ReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1-3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "countReachableEdgesIncoming": 
            case "countReachableEdgesOutgoing": 
            case "countReachableEdges": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 1) {
                    return new CountReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 2) {
                    return new CountReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new CountReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1-3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "countReachableIncoming": 
            case "countReachableOutgoing": 
            case "countReachable": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 1) {
                    return new CountReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 2) {
                    return new CountReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new CountReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), direction, collectNode.get(2));
                }
                resolvingEnvironment.reportError(string + "() expects 1-3 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "isReachableIncoming": 
            case "isReachableOutgoing": 
            case "isReachable": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new IsReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new IsReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new IsReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "isReachableEdgesIncoming": 
            case "isReachableEdgesOutgoing": 
            case "isReachableEdges": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new IsReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new IsReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new IsReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "boundedReachableEdgesIncoming": 
            case "boundedReachableEdgesOutgoing": 
            case "boundedReachableEdges": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new BoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new BoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new BoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "boundedReachableIncoming": 
            case "boundedReachableOutgoing": 
            case "boundedReachable": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new BoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new BoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new BoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "boundedReachableWithRemainingDepthIncoming": 
            case "boundedReachableWithRemainingDepthOutgoing": 
            case "boundedReachableWithRemainingDepth": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new BoundedReachableNodeWithRemainingDepthExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new BoundedReachableNodeWithRemainingDepthExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new BoundedReachableNodeWithRemainingDepthExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "countBoundedReachableEdgesIncoming": 
            case "countBoundedReachableEdgesOutgoing": 
            case "countBoundedReachableEdges": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new CountBoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new CountBoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new CountBoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "countBoundedReachableIncoming": 
            case "countBoundedReachableOutgoing": 
            case "countBoundedReachable": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 2) {
                    return new CountBoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 3) {
                    return new CountBoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new CountBoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), direction, collectNode.get(3));
                }
                resolvingEnvironment.reportError(string + "() expects 2-4 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "isBoundedReachableIncoming": 
            case "isBoundedReachableOutgoing": 
            case "isBoundedReachable": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 3) {
                    return new IsBoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new IsBoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), collectNode.get(3), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 5) {
                    return new IsBoundedReachableNodeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), collectNode.get(3), direction, collectNode.get(4));
                }
                resolvingEnvironment.reportError(string + "() expects 3-5 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "isBoundedReachableEdgesIncoming": 
            case "isBoundedReachableEdgesOutgoing": 
            case "isBoundedReachableEdges": {
                Direction direction = FunctionInvocationDecisionNode.getDirection(string);
                if (collectNode.size() == 3) {
                    return new IsBoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), new IdentExprNode(resolvingEnvironment.getParserEnvironment().getArbitraryEdgeRoot()), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 4) {
                    return new IsBoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), collectNode.get(3), direction, new IdentExprNode(resolvingEnvironment.getParserEnvironment().getNodeRoot()));
                }
                if (collectNode.size() == 5) {
                    return new IsBoundedReachableEdgeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), collectNode.get(2), collectNode.get(3), direction, collectNode.get(4));
                }
                resolvingEnvironment.reportError(string + "() expects 3-5 arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "inducedSubgraph": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("inducedSubgraph() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new InducedSubgraphExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "definedSubgraph": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("definedSubgraph() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new DefinedSubgraphExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "equalsAny": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("equalsAny() expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new EqualsAnyExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), true);
            }
            case "equalsAnyStructurally": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("equalsAnyStructurally() expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new EqualsAnyExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), false);
            }
            case "getEquivalent": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("getEquivalent() expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new GetEquivalentExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), true);
            }
            case "getEquivalentStructurally": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("getEquivalentStructurally() expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new GetEquivalentExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1), false);
            }
            case "copy": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("copy() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new CopyExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), true);
            }
            case "clone": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("clone() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new CopyExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), false);
            }
            case "canonize": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("canonize() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new CanonizeExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "uniqueof": {
                if (collectNode.size() > 1) {
                    resolvingEnvironment.reportError("uniqueof() expects 1 or 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                if (collectNode.size() == 1) {
                    return new UniqueofExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
                }
                return new UniqueofExprNode(resolvingEnvironment.getCoords(), null);
            }
            case "graphof": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("graphof() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new GraphofExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
        }
        resolvingEnvironment.reportError("A function of name " + string + " is not known.");
        return null;
    }

    public static Direction getDirection(String string) {
        switch (string) {
            case "adjacentIncoming": 
            case "countAdjacentIncoming": 
            case "isAdjacentIncoming": 
            case "reachableIncoming": 
            case "countReachableIncoming": 
            case "isReachableIncoming": 
            case "boundedReachableIncoming": 
            case "boundedReachableWithRemainingDepthIncoming": 
            case "countBoundedReachableIncoming": 
            case "isBoundedReachableIncoming": {
                return Direction.INCOMING;
            }
            case "adjacentOutgoing": 
            case "countAdjacentOutgoing": 
            case "isAdjacentOutgoing": 
            case "reachableOutgoing": 
            case "countReachableOutgoing": 
            case "isReachableOutgoing": 
            case "boundedReachableOutgoing": 
            case "boundedReachableWithRemainingDepthOutgoing": 
            case "countBoundedReachableOutgoing": 
            case "isBoundedReachableOutgoing": {
                return Direction.OUTGOING;
            }
            case "adjacent": 
            case "countAdjacent": 
            case "isAdjacent": 
            case "reachable": 
            case "countReachable": 
            case "isReachable": 
            case "boundedReachable": 
            case "boundedReachableWithRemainingDepth": 
            case "countBoundedReachable": 
            case "isBoundedReachable": {
                return Direction.INCIDENT;
            }
            case "incoming": 
            case "countIncoming": 
            case "isIncoming": 
            case "reachableEdgesIncoming": 
            case "countReachableEdgesIncoming": 
            case "isReachableEdgesIncoming": 
            case "boundedReachableEdgesIncoming": 
            case "countBoundedReachableEdgesIncoming": 
            case "isBoundedReachableEdgesIncoming": {
                return Direction.INCOMING;
            }
            case "outgoing": 
            case "countOutgoing": 
            case "isOutgoing": 
            case "reachableEdgesOutgoing": 
            case "countReachableEdgesOutgoing": 
            case "isReachableEdgesOutgoing": 
            case "boundedReachableEdgesOutgoing": 
            case "countBoundedReachableEdgesOutgoing": 
            case "isBoundedReachableEdgesOutgoing": {
                return Direction.OUTGOING;
            }
            case "incident": 
            case "countIncident": 
            case "isIncident": 
            case "reachableEdges": 
            case "countReachableEdges": 
            case "isReachableEdges": 
            case "boundedReachableEdges": 
            case "countBoundedReachableEdges": 
            case "isBoundedReachableEdges": {
                return Direction.INCIDENT;
            }
        }
        return Direction.INVALID;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.result.getType();
    }

    public ExprNode getResult() {
        return this.result;
    }

    @Override
    protected IR constructIR() {
        return this.result.getIR();
    }

    static {
        FunctionInvocationDecisionNode.setName(FunctionInvocationDecisionNode.class, "function invocation decision expression");
        functionTypeNode = new FunctionTypeNode();
    }
}

