/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.ScopeOwner;
import de.unika.ipd.grgen.ast.decl.executable.ExternalFunctionDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.ExternalFunction;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.invocation.ExternalFunctionMethodInvocationExpr;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class ExternalFunctionMethodInvocationExprNode
extends FunctionInvocationBaseNode {
    private ExprNode owner;
    private IdentNode externalFunctionUnresolved;
    private ExternalFunctionDeclNode externalFunctionDecl;
    private static final DeclarationResolver<ExternalFunctionDeclNode> resolver;

    public ExternalFunctionMethodInvocationExprNode(ExprNode exprNode, IdentNode identNode, CollectNode<ExprNode> collectNode) {
        super(identNode.getCoords(), collectNode);
        this.owner = this.becomeParent(exprNode);
        this.externalFunctionUnresolved = this.becomeParent(identNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.owner);
        vector.add(this.getValidVersion(this.externalFunctionUnresolved, this.externalFunctionDecl));
        vector.add(this.arguments);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("owner");
        vector.add("external function method");
        vector.add("arguments");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        TypeNode typeNode = this.owner.getType();
        if (typeNode instanceof ExternalObjectTypeNode) {
            if (typeNode instanceof ScopeOwner) {
                ScopeOwner scopeOwner = (ScopeOwner)((Object)typeNode);
                scopeOwner.fixupDefinition(this.externalFunctionUnresolved);
                this.externalFunctionDecl = (ExternalFunctionDeclNode)resolver.resolve(this.externalFunctionUnresolved, this);
                if (this.externalFunctionDecl == null) {
                    this.externalFunctionUnresolved.reportError("An external function method of name " + this.externalFunctionUnresolved + " is not known. Is it a misspelled function name? Or is a procedure call intended (this is not possible in an expression, an assignment target must be given as (param,...)=call in that case)?");
                    return false;
                }
                bl = this.externalFunctionDecl != null && bl;
            } else {
                this.reportError("Left hand side of '.' does not own a scope.");
                bl = false;
            }
        } else {
            this.reportError("Left hand side of '.' is not an external type.");
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        return this.checkSignatureAdhered(this.externalFunctionDecl, this.externalFunctionUnresolved, true);
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.externalFunctionDecl.getResultType();
    }

    @Override
    protected IR constructIR() {
        this.owner = this.owner.evaluate();
        ExternalFunctionMethodInvocationExpr externalFunctionMethodInvocationExpr = new ExternalFunctionMethodInvocationExpr(this.owner.checkIR(Expression.class), this.externalFunctionDecl.resultType.checkIR(Type.class), this.externalFunctionDecl.checkIR(ExternalFunction.class));
        for (ExprNode exprNode : this.arguments.getChildren()) {
            exprNode = exprNode.evaluate();
            externalFunctionMethodInvocationExpr.addArgument(exprNode.checkIR(Expression.class));
        }
        return externalFunctionMethodInvocationExpr;
    }

    static {
        ExternalFunctionMethodInvocationExprNode.setName(ExternalFunctionMethodInvocationExprNode.class, "external function method invocation expression");
        resolver = new DeclarationResolver<ExternalFunctionDeclNode>(ExternalFunctionDeclNode.class);
    }
}

