/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.SourceExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class SourceExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode edge;
    private IdentNode nodeTypeUnresolved;
    private NodeTypeNode nodeType;
    private static final DeclarationTypeResolver<NodeTypeNode> nodeTypeResolver;

    public SourceExprNode(Coords coords, ExprNode exprNode, IdentNode identNode) {
        super(coords);
        this.edge = exprNode;
        this.becomeParent(this.edge);
        this.nodeTypeUnresolved = identNode;
        this.becomeParent(this.nodeTypeUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.edge);
        vector.add(this.getValidVersion(this.nodeTypeUnresolved, this.nodeType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("edge");
        vector.add("nodeType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.nodeType = (NodeTypeNode)nodeTypeResolver.resolve(this.nodeTypeUnresolved, this);
        return this.nodeType != null && this.getType().resolve();
    }

    @Override
    protected boolean checkLocal() {
        if (!(this.edge.getType() instanceof EdgeTypeNode)) {
            this.reportError("The function source expects as argument (edgeToGetSourceNodeFrom) a value of type edge (but is given a value of type " + this.edge.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.edge = this.edge.evaluate();
        return new SourceExpr(this.edge.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.nodeType;
    }

    static {
        SourceExprNode.setName(SourceExprNode.class, "source expr");
        nodeTypeResolver = new DeclarationTypeResolver<NodeTypeNode>(NodeTypeNode.class);
    }
}

