/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.OppositeExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class OppositeExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode edge;
    private ExprNode node;
    private IdentNode nodeTypeUnresolved;
    private NodeTypeNode nodeType;
    private static final DeclarationTypeResolver<NodeTypeNode> nodeTypeResolver;

    public OppositeExprNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, IdentNode identNode) {
        super(coords);
        this.edge = exprNode;
        this.becomeParent(this.edge);
        this.node = exprNode2;
        this.becomeParent(this.node);
        this.nodeTypeUnresolved = identNode;
        this.becomeParent(this.nodeTypeUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.edge);
        vector.add(this.node);
        vector.add(this.getValidVersion(this.nodeTypeUnresolved, this.nodeType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("edge");
        vector.add("node");
        vector.add("nodeType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.nodeType = (NodeTypeNode)nodeTypeResolver.resolve(this.nodeTypeUnresolved, this);
        return this.nodeType != null && this.getType().resolve();
    }

    @Override
    protected boolean checkLocal() {
        if (!(this.edge.getType() instanceof EdgeTypeNode)) {
            this.reportError("The function opposite expects as 1. argument (edgeToObtainOppositeNodeFrom) a value of type edge (but is given a value of type " + this.edge.getType().getTypeName() + ").");
            return false;
        }
        if (!(this.node.getType() instanceof NodeTypeNode)) {
            this.reportError("The function opposite expects as 2. argument (originalNode) a value of type node (but is given a value of type " + this.node.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.edge = this.edge.evaluate();
        this.node = this.node.evaluate();
        return new OppositeExpr(this.edge.checkIR(Expression.class), this.node.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.nodeType;
    }

    static {
        OppositeExprNode.setName(OppositeExprNode.class, "opposite expr");
        nodeTypeResolver = new DeclarationTypeResolver<NodeTypeNode>(NodeTypeNode.class);
    }
}

