/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.Nameof;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class NameofNode
extends ExprNode {
    private ExprNode namedEntity;

    public NameofNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.namedEntity = exprNode;
        this.becomeParent(this.namedEntity);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        if (this.namedEntity != null) {
            vector.add(this.namedEntity);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        if (this.namedEntity != null) {
            vector.add("named entity");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.namedEntity != null) {
            if (this.namedEntity.getType().isEqual(BasicTypeNode.graphType)) {
                return true;
            }
            if (this.namedEntity.getType() instanceof EdgeTypeNode) {
                return true;
            }
            if (this.namedEntity.getType() instanceof NodeTypeNode) {
                return true;
            }
            this.reportError("The function nameof expects as argument (entityToFetchNameOf) a value of type node or edge or graph (but is given a value of type " + this.namedEntity.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.namedEntity == null) {
            return new Nameof(null, this.getType().getType());
        }
        this.namedEntity = this.namedEntity.evaluate();
        return new Nameof(this.namedEntity.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.stringType;
    }

    static {
        NameofNode.setName(NameofNode.class, "nameof");
    }
}

