/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.graph.FromIndexAccessExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public abstract class FromIndexAccessFromToExprNode
extends FromIndexAccessExprNode {
    protected ExprNode fromExpr;
    protected boolean fromExclusive;
    protected ExprNode toExpr;
    protected boolean toExclusive;

    public FromIndexAccessFromToExprNode(Coords coords, BaseNode baseNode, ExprNode exprNode, boolean bl, ExprNode exprNode2, boolean bl2) {
        super(coords, baseNode);
        this.fromExpr = exprNode;
        this.becomeParent(this.fromExpr);
        this.fromExclusive = bl;
        this.toExpr = exprNode2;
        this.becomeParent(this.toExpr);
        this.toExclusive = bl2;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.indexUnresolved, this.index));
        if (this.fromExpr != null) {
            vector.add(this.fromExpr);
        }
        if (this.toExpr != null) {
            vector.add(this.toExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("index");
        if (this.fromExpr != null) {
            vector.add("fromExpr");
        }
        if (this.toExpr != null) {
            vector.add("toExpr");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        if (this.fromExpr != null) {
            bl &= this.fromExpr.resolve();
        }
        if (this.toExpr != null) {
            bl &= this.toExpr.resolve();
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode;
        boolean bl = super.checkLocal();
        TypeNode typeNode2 = this.index.getExpectedAccessType();
        if (this.fromExpr != null && !(typeNode = this.fromExpr.getType()).isCompatibleTo(typeNode2)) {
            String string = typeNode2.getTypeName();
            String string2 = typeNode.getTypeName();
            int n = 2 + this.indexShift();
            this.reportError("The function " + this.shortSignature() + " expects as " + n + ". argument (fromExpr) a value of type " + string + " (but is given a value of type " + string2 + ").");
            return false;
        }
        if (this.toExpr != null && !(typeNode = this.toExpr.getType()).isCompatibleTo(typeNode2)) {
            String string = typeNode2.getTypeName();
            String string3 = typeNode.getTypeName();
            int n = (this.fromExpr != null ? 3 : 2) + this.indexShift();
            this.reportError("The function " + this.shortSignature() + " expects as " + n + ". argument (toExpr) a value of type " + string + " (but is given a value of type " + string3 + ").");
            return false;
        }
        return bl;
    }

    protected String fromPart() {
        if (this.fromExpr == null) {
            return "";
        }
        return this.fromExclusive ? "FromExclusive" : "From";
    }

    protected String toPart() {
        if (this.toExpr == null) {
            return "";
        }
        return this.toExclusive ? "ToExclusive" : "To";
    }

    protected String argumentsPart() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".");
        if (this.fromExpr != null) {
            stringBuilder.append(",.");
        }
        if (this.toExpr != null) {
            stringBuilder.append(",.");
        }
        return stringBuilder.toString();
    }

    protected OperatorDeclNode.Operator fromOperator() {
        return this.fromExclusive ? OperatorDeclNode.Operator.GT : OperatorDeclNode.Operator.GE;
    }

    protected OperatorDeclNode.Operator toOperator() {
        return this.toExclusive ? OperatorDeclNode.Operator.LT : OperatorDeclNode.Operator.LE;
    }

    static {
        FromIndexAccessFromToExprNode.setName(FromIndexAccessFromToExprNode.class, "from index access from to expr");
    }
}

