/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.model.decl.IndexDeclNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.Coords;

public abstract class FromIndexAccessExprNode
extends BuiltinFunctionInvocationBaseNode {
    protected BaseNode indexUnresolved;
    protected IndexDeclNode index;
    private static DeclarationResolver<IndexDeclNode> indexResolver;

    protected FromIndexAccessExprNode(Coords coords, BaseNode baseNode) {
        super(coords);
        this.indexUnresolved = baseNode;
        this.becomeParent(this.indexUnresolved);
    }

    @Override
    protected boolean resolveLocal() {
        this.index = (IndexDeclNode)indexResolver.resolve(this.indexUnresolved, this);
        if (this.index == null) {
            int n = 1 + this.indexShift();
            this.reportError("The function " + this.shortSignature() + " expects as " + n + ". argument (index) a declared index (given is " + this.indexUnresolved.toStringWithDeclarationCoords() + ").");
        }
        return this.index != null;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        TypeNode typeNode = this.getRoot().getDecl().getDeclType();
        InheritanceTypeNode inheritanceTypeNode = this.index.getType();
        if (!inheritanceTypeNode.isCompatibleTo(typeNode)) {
            int n = 1 + this.indexShift();
            this.reportError("The function " + this.shortSignature() + " expects as " + n + ". argument (index) a value of type index on " + typeNode.toStringWithDeclarationCoords() + " (but is given a value of type index on " + inheritanceTypeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return bl;
    }

    protected int indexShift() {
        return 0;
    }

    protected abstract IdentNode getRoot();

    protected abstract String shortSignature();

    @Override
    protected abstract IR constructIR();

    static {
        FromIndexAccessExprNode.setName(FromIndexAccessExprNode.class, "from index access expr");
        indexResolver = new DeclarationResolver<IndexDeclNode>(IndexDeclNode.class);
    }
}

