/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.EdgeByNameExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class EdgeByNameExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode name;
    private ExprNode edgeType;

    public EdgeByNameExprNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.name = exprNode;
        this.becomeParent(this.name);
        this.edgeType = exprNode2;
        this.becomeParent(this.edgeType);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.name);
        vector.add(this.edgeType);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("name");
        vector.add("edgeType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if (!(this.name.getType() instanceof StringTypeNode)) {
            this.reportError("The function edgeByName expects as 1. argument (nameToSearchFor) a value of type string (but is given a value of type " + this.name.getType().getTypeName() + ").");
            return false;
        }
        if (!(this.edgeType.getType() instanceof EdgeTypeNode)) {
            this.reportError("The function edgeByName expects as 2. argument (typeToObtain) a value of type edge type (but is given a value of type " + this.edgeType.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.name = this.name.evaluate();
        this.edgeType = this.edgeType.evaluate();
        return new EdgeByNameExpr(this.name.checkIR(Expression.class), this.edgeType.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.edgeType.getType();
    }

    static {
        EdgeByNameExprNode.setName(EdgeByNameExprNode.class, "edge by name expr");
    }
}

