/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.decl.IncidenceCountIndexDeclNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.CountIncidenceFromIndexExpr;
import de.unika.ipd.grgen.ir.model.IncidenceCountIndex;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class CountIncidenceFromIndexExprNode
extends BuiltinFunctionInvocationBaseNode {
    private BaseNode indexUnresolved;
    private IncidenceCountIndexDeclNode index;
    private ExprNode keyExpr;
    private static DeclarationResolver<IncidenceCountIndexDeclNode> indexResolver;

    public CountIncidenceFromIndexExprNode(Coords coords, BaseNode baseNode, ExprNode exprNode) {
        super(coords);
        this.indexUnresolved = this.becomeParent(baseNode);
        this.keyExpr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.indexUnresolved, this.index));
        vector.add(this.keyExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("index");
        vector.add("keyExpr");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        this.index = (IncidenceCountIndexDeclNode)indexResolver.resolve(this.indexUnresolved, this);
        if (this.index == null) {
            this.reportError("The function countFromIndex(.,.) expects as 1. argument (index) an incidence count index (but is given " + this.indexUnresolved.toStringWithDeclarationCoords() + ").");
        }
        return bl &= this.index != null;
    }

    @Override
    protected boolean checkLocal() {
        InheritanceTypeNode inheritanceTypeNode = this.index.getType();
        TypeNode typeNode = this.keyExpr.getType();
        if (typeNode instanceof InheritanceTypeNode) {
            if (typeNode.isCompatibleTo(inheritanceTypeNode)) {
                return true;
            }
            String string = typeNode.getTypeName();
            String string2 = ((TypeNode)inheritanceTypeNode).getTypeName();
            this.reportError("The function countFromIndex(.,.) expects as 2. argument (keyExpr) a value of type " + string2 + " (but is given a value of type " + string + ").");
            return false;
        }
        if (typeNode.isEqual(inheritanceTypeNode)) {
            return true;
        }
        this.keyExpr = this.becomeParent(this.keyExpr.adjustType(inheritanceTypeNode, this.getCoords()));
        return this.keyExpr != ConstNode.getInvalid();
    }

    @Override
    public TypeNode getType() {
        return IntTypeNode.intType;
    }

    @Override
    protected IR constructIR() {
        this.keyExpr = this.keyExpr.evaluate();
        return new CountIncidenceFromIndexExpr(this.index.checkIR(IncidenceCountIndex.class), this.keyExpr.checkIR(Expression.class));
    }

    static {
        CountIncidenceFromIndexExprNode.setName(CountIncidenceFromIndexExprNode.class, "count incidence from index access expression");
        indexResolver = new DeclarationResolver<IncidenceCountIndexDeclNode>(IncidenceCountIndexDeclNode.class);
    }
}

