/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.deque;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ContainerSingleElementInitNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ast.util.MemberResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.deque.DequeInit;
import de.unika.ipd.grgen.ir.type.container.DequeType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Vector;

public class DequeInitNode
extends ContainerSingleElementInitNode {
    private BaseNode lhsUnresolved;
    private DeclNode lhs;
    private DequeTypeNode dequeType;
    private static final MemberResolver<DeclNode> lhsResolver;

    public DequeInitNode(Coords coords, IdentNode identNode, DequeTypeNode dequeTypeNode) {
        super(coords);
        if (identNode != null) {
            this.lhsUnresolved = this.becomeParent(identNode);
        } else {
            this.dequeType = dequeTypeNode;
        }
    }

    @Override
    protected boolean resolveLocal() {
        if (this.lhsUnresolved != null) {
            if (!lhsResolver.resolve(this.lhsUnresolved)) {
                return false;
            }
            this.lhs = lhsResolver.getResult(DeclNode.class);
            return lhsResolver.finish();
        }
        if (this.dequeType == null) {
            this.dequeType = this.createDequeType();
        }
        return this.dequeType.resolve();
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = this.checkContainerItems();
        if (!this.isConstant() && this.lhs != null) {
            this.reportError("Only constant items are allowed in a deque initialization in the model.");
            bl = false;
        }
        return bl;
    }

    protected DequeTypeNode createDequeType() {
        TypeNode typeNode = ((ExprNode)this.containerItems.getChildren().iterator().next()).getType();
        IdentNode identNode = ((DeclaredTypeNode)typeNode).getIdentNode();
        return new DequeTypeNode(identNode);
    }

    @Override
    public DequeTypeNode getContainerType() {
        assert (this.isResolved());
        if (this.lhs != null) {
            TypeNode typeNode = this.lhs.getDeclType();
            return (DequeTypeNode)typeNode;
        }
        return this.dequeType;
    }

    @Override
    public boolean isInitInModel() {
        return this.dequeType == null;
    }

    public ExprNode getAtIndex(ConstNode constNode) {
        Integer n = (Integer)constNode.getValue();
        if (n < 0) {
            return null;
        }
        if (n >= this.containerItems.size()) {
            return null;
        }
        return (ExprNode)this.containerItems.getChildrenAsVector().get(n);
    }

    @Override
    protected IR constructIR() {
        Vector<Expression> vector = this.constructItems();
        Entity entity = this.lhs != null ? this.lhs.getEntity() : null;
        DequeType dequeType = this.dequeType != null ? this.dequeType.checkIR(DequeType.class) : null;
        return new DequeInit(vector, entity, dequeType, this.isConstant());
    }

    public DequeInit getDequeInit() {
        return this.checkIR(DequeInit.class);
    }

    public static String getKindStr() {
        return "deque initialization";
    }

    static {
        DequeInitNode.setName(DequeInitNode.class, "deque init");
        lhsResolver = new MemberResolver();
    }
}

