/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayRemoveIfExpr;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ArrayRemoveIfNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    private VarDeclNode arrayAccessVar;
    private VarDeclNode indexVar;
    private VarDeclNode elementVar;
    private ExprNode conditionExpr;

    public ArrayRemoveIfNode(Coords coords, ExprNode exprNode, VarDeclNode varDeclNode, VarDeclNode varDeclNode2, VarDeclNode varDeclNode3, ExprNode exprNode2) {
        super(coords, exprNode);
        this.arrayAccessVar = varDeclNode;
        this.indexVar = varDeclNode2;
        this.elementVar = varDeclNode3;
        this.conditionExpr = exprNode2;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.targetExpr);
        if (this.arrayAccessVar != null) {
            vector.add(this.arrayAccessVar);
        }
        if (this.indexVar != null) {
            vector.add(this.indexVar);
        }
        vector.add(this.elementVar);
        vector.add(this.conditionExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        if (this.arrayAccessVar != null) {
            vector.add("arrayAccessVar");
        }
        if (this.indexVar != null) {
            vector.add("indexVar");
        }
        vector.add("elementVar");
        vector.add("conditionExpr");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = this.targetExpr.resolve();
        if (!bl) {
            return false;
        }
        this.getTargetType();
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode;
        TypeNode typeNode2 = this.conditionExpr.getType();
        if (this.arrayAccessVar != null) {
            typeNode = this.arrayAccessVar.getDeclType();
            if (!(typeNode instanceof ArrayTypeNode)) {
                this.reportError("The array access variable of the array removeIf function method must be of array type (but is of type " + typeNode.getTypeName() + ").");
                return false;
            }
            if (!typeNode.isEqual(this.targetExpr.getType())) {
                this.reportError("The array access variable of the array removeIf function method must be of type " + this.targetExpr.getType().getTypeName() + " (but is of type " + typeNode.getTypeName() + ").");
                return false;
            }
        }
        if (this.indexVar != null && !(typeNode = this.indexVar.getDeclType()).isEqual(BasicTypeNode.intType)) {
            this.reportError("The index variable of the array removeIf function method must be of int type (but is of type " + typeNode.getTypeName() + ").");
            return false;
        }
        if (!typeNode2.isEqual(BasicTypeNode.booleanType)) {
            this.reportError("Type mismatch in the array removeIf function method between the lambda expression value of type " + typeNode2.getTypeName() + " and the expected boolean type.");
            return false;
        }
        typeNode = this.elementVar.getDeclType();
        TypeNode typeNode3 = ((ArrayTypeNode)this.targetExpr.getType()).valueType;
        if (typeNode3 instanceof NodeTypeNode && typeNode instanceof EdgeTypeNode || typeNode3 instanceof EdgeTypeNode && typeNode instanceof NodeTypeNode) {
            this.reportError("Cannot bind the element variable of " + typeNode.getKind() + " " + typeNode.getTypeName() + " to a value of " + typeNode3.getKind() + " " + typeNode3.getTypeName() + " in the array removeIf function method.");
            return false;
        }
        if (!typeNode3.isCompatibleTo(typeNode)) {
            this.reportError("Cannot bind the element variable of type " + typeNode.toStringWithDeclarationCoords() + " to a value of type " + typeNode3.toStringWithDeclarationCoords() + " in the array removeIf function method.");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.getTargetType();
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        this.conditionExpr = this.conditionExpr.evaluate();
        return new ArrayRemoveIfExpr(this.targetExpr.checkIR(Expression.class), this.arrayAccessVar != null ? this.arrayAccessVar.checkIR(Variable.class) : null, this.indexVar != null ? this.indexVar.checkIR(Variable.class) : null, this.elementVar.checkIR(Variable.class), this.conditionExpr.checkIR(Expression.class), this.getTargetType().checkIR(ArrayType.class));
    }

    static {
        ArrayRemoveIfNode.setName(ArrayRemoveIfNode.class, "array removeIf");
    }
}

