/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayOrderAscendingBy;
import de.unika.ipd.grgen.parser.Coords;

public class ArrayOrderAscendingByNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    private IdentNode attribute;
    private DeclNode member;

    public ArrayOrderAscendingByNode(Coords coords, ExprNode exprNode, IdentNode identNode) {
        super(coords, exprNode);
        this.attribute = identNode;
    }

    @Override
    protected boolean checkLocal() {
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!(arrayTypeNode.valueType instanceof InheritanceTypeNode) && !(arrayTypeNode.valueType instanceof MatchTypeNode)) {
            this.targetExpr.reportError("The array function method orderAscendingBy can only be employed on an object of type array<nodes, edges, class objects, transient class objects, match types, match class types> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
            return false;
        }
        TypeNode typeNode = arrayTypeNode.valueType;
        this.member = Resolver.resolveMember(typeNode, this.attribute);
        if (this.member == null) {
            return false;
        }
        TypeNode typeNode2 = this.getTypeOfElementToBeExtracted();
        if (!typeNode2.isOrderableType()) {
            this.targetExpr.reportError("The array function method orderAscendingBy is only available for attributes of type " + TypeNode.getOrderableTypesAsString() + " (but is of type " + typeNode2.getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.getTargetType();
    }

    private TypeNode getTypeOfElementToBeExtracted() {
        if (this.member != null) {
            return this.member.getDeclType();
        }
        return null;
    }

    @Override
    protected IR constructIR() {
        Entity entity = null;
        if (this.member != null) {
            entity = this.member.checkIR(Entity.class);
        }
        this.targetExpr = this.targetExpr.evaluate();
        return new ArrayOrderAscendingBy(this.targetExpr.checkIR(Expression.class), entity);
    }

    static {
        ArrayOrderAscendingByNode.setName(ArrayOrderAscendingByNode.class, "array order ascending by");
    }
}

