/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAccumulationMethodNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayOrExpr;
import de.unika.ipd.grgen.parser.Coords;

public class ArrayOrNode
extends ArrayAccumulationMethodNode {
    public ArrayOrNode(Coords coords, ExprNode exprNode) {
        super(coords, exprNode);
    }

    @Override
    protected boolean checkLocal() {
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!arrayTypeNode.valueType.isEqual(BasicTypeNode.booleanType)) {
            this.targetExpr.reportError("The array function method or can only be employed on an object of type array<boolean> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.booleanType;
    }

    @Override
    public boolean isValidTargetTypeOfAccumulation(TypeNode typeNode) {
        return typeNode.isEqual(BasicTypeNode.booleanType);
    }

    @Override
    public String getValidTargetTypesOfAccumulation() {
        return "boolean";
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        return new ArrayOrExpr(this.targetExpr.checkIR(Expression.class));
    }

    static {
        ArrayOrNode.setName(ArrayOrNode.class, "array or");
    }
}

