/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayIndexOfOrderedByExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ArrayIndexOfOrderedByNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    IdentNode attribute;
    private DeclNode member;
    private ExprNode valueExpr;

    public ArrayIndexOfOrderedByNode(Coords coords, ExprNode exprNode, IdentNode identNode, ExprNode exprNode2) {
        super(coords, exprNode);
        this.attribute = identNode;
        this.valueExpr = this.becomeParent(exprNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.targetExpr);
        vector.add(this.valueExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        vector.add("valueExpr");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode;
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!(arrayTypeNode.valueType instanceof InheritanceTypeNode) && !(arrayTypeNode.valueType instanceof MatchTypeNode)) {
            this.targetExpr.reportError("The array function method indexOfOrderedBy can only be employed on an object of type array<nodes, edges, class objects, transient class objects, match types, match class types> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
            return false;
        }
        this.member = Resolver.resolveMember(arrayTypeNode.valueType, this.attribute);
        if (this.member == null) {
            return false;
        }
        TypeNode typeNode2 = this.member.getDeclType();
        if (!(typeNode2.equals(BasicTypeNode.byteType) || typeNode2.equals(BasicTypeNode.shortType) || typeNode2.equals(BasicTypeNode.intType) || typeNode2.equals(BasicTypeNode.longType) || typeNode2.equals(BasicTypeNode.floatType) || typeNode2.equals(BasicTypeNode.doubleType) || typeNode2.equals(BasicTypeNode.stringType) || typeNode2.equals(BasicTypeNode.booleanType) || typeNode2 instanceof EnumTypeNode)) {
            this.targetExpr.reportError("The array function method indexOfOrderedBy is only available for attributes of type byte, short, int, long, float, double, string, boolean, enum of a graph element (but is of type " + typeNode2.getTypeName() + ")");
        }
        if (!(typeNode = this.valueExpr.getType()).isEqual(typeNode2)) {
            ExprNode exprNode = this.valueExpr;
            this.valueExpr = this.becomeParent(this.valueExpr.adjustType(typeNode2, this.getCoords()));
            if (this.valueExpr == ConstNode.getInvalid()) {
                exprNode.reportError("The array function method indexOfOrderedBy expects as 1. argument (valueToSearchFor) a value of type " + typeNode2.getTypeName() + " (but is given a value of type " + typeNode.getTypeName() + ").");
                return false;
            }
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.intType;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        this.valueExpr = this.valueExpr.evaluate();
        return new ArrayIndexOfOrderedByExpr(this.targetExpr.checkIR(Expression.class), this.member.checkIR(Entity.class), this.valueExpr.checkIR(Expression.class));
    }

    static {
        ArrayIndexOfOrderedByNode.setName(ArrayIndexOfOrderedByNode.class, "array index of ordered by");
    }
}

