/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayFunctionMethodInvocationBaseExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayGroup;
import de.unika.ipd.grgen.parser.Coords;

public class ArrayGroupNode
extends ArrayFunctionMethodInvocationBaseExprNode {
    public ArrayGroupNode(Coords coords, ExprNode exprNode) {
        super(coords, exprNode);
    }

    @Override
    protected boolean checkLocal() {
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!arrayTypeNode.valueType.isFilterableType()) {
            this.targetExpr.reportError("The array function method group can only be employed on an object of type array<" + TypeNode.getFilterableTypesAsString() + "> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.getTargetType();
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        return new ArrayGroup(this.targetExpr.checkIR(Expression.class));
    }

    static {
        ArrayGroupNode.setName(ArrayGroupNode.class, "array group");
    }
}

