/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAccumulationMethodNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayDevExpr;
import de.unika.ipd.grgen.parser.Coords;

public class ArrayDevNode
extends ArrayAccumulationMethodNode {
    public ArrayDevNode(Coords coords, ExprNode exprNode) {
        super(coords, exprNode);
    }

    @Override
    protected boolean checkLocal() {
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!arrayTypeNode.valueType.isAccumulatableType()) {
            this.targetExpr.reportError("The array function method dev can only be employed on an object of type array<" + TypeNode.getAccumulatableTypesAsString() + "> (but is employed on an object of type " + arrayTypeNode.getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.doubleType;
    }

    @Override
    public boolean isValidTargetTypeOfAccumulation(TypeNode typeNode) {
        return typeNode.isEqual(BasicTypeNode.doubleType);
    }

    @Override
    public String getValidTargetTypesOfAccumulation() {
        return "double";
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        return new ArrayDevExpr(this.targetExpr.checkIR(Expression.class));
    }

    static {
        ArrayDevNode.setName(ArrayDevNode.class, "array dev");
    }
}

