/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.array;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.array.ArrayCopyConstructor;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ArrayCopyConstructorNode
extends ExprNode {
    private ArrayTypeNode arrayType;
    private ExprNode arrayToCopy;
    private BaseNode lhsUnresolved;

    public ArrayCopyConstructorNode(Coords coords, IdentNode identNode, ArrayTypeNode arrayTypeNode, ExprNode exprNode) {
        super(coords);
        if (identNode != null) {
            this.lhsUnresolved = this.becomeParent(identNode);
        } else {
            this.arrayType = arrayTypeNode;
        }
        this.arrayToCopy = exprNode;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.arrayToCopy);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("arrayToCopy");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.arrayType != null) {
            return this.arrayType.resolve();
        }
        return true;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        if (this.lhsUnresolved != null) {
            this.reportError("An array copy constructor is not allowed in an array initialization in the model.");
            bl = false;
        } else if (this.arrayToCopy.getType() instanceof ArrayTypeNode) {
            ArrayTypeNode arrayTypeNode = (ArrayTypeNode)this.arrayToCopy.getType();
            bl &= this.checkCopyConstructorTypes(this.arrayType.valueType, arrayTypeNode.valueType, "array", false);
        } else {
            this.reportError("An array copy constructor expects a value of array type to copy (but is given " + this.arrayToCopy.getType().getTypeName() + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.arrayType;
    }

    @Override
    protected IR constructIR() {
        this.arrayToCopy = this.arrayToCopy.evaluate();
        return new ArrayCopyConstructor(this.arrayToCopy.checkIR(Expression.class), this.arrayType.checkIR(ArrayType.class));
    }

    public static String getKindStr() {
        return "array copy constructor";
    }

    static {
        ArrayCopyConstructorNode.setName(ArrayCopyConstructorNode.class, "array copy constructor");
    }
}

