/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTripleResolver;
import de.unika.ipd.grgen.ast.util.Triple;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Typeof;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class TypeofNode
extends ExprNode {
    private IdentNode entityUnresolved;
    private EdgeDeclNode entityEdgeDecl = null;
    private NodeDeclNode entityNodeDecl = null;
    private VarDeclNode entityVarDecl = null;
    private static final DeclarationTripleResolver<EdgeDeclNode, NodeDeclNode, VarDeclNode> entityResolver;

    public TypeofNode(Coords coords, IdentNode identNode) {
        super(coords);
        this.entityUnresolved = identNode;
        this.becomeParent(this.entityUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.entityUnresolved, this.entityEdgeDecl, this.entityNodeDecl, this.entityVarDecl));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("entity");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = TypeofNode.fixupDefinition(this.entityUnresolved, this.entityUnresolved.getScope());
        Object object = entityResolver.resolve(this.entityUnresolved, this);
        if (object != null) {
            this.entityEdgeDecl = (EdgeDeclNode)((Triple)object).first;
            this.entityNodeDecl = (NodeDeclNode)((Triple)object).second;
            this.entityVarDecl = (VarDeclNode)((Triple)object).third;
        }
        return bl && object != null;
    }

    @Override
    protected boolean checkLocal() {
        if (this.entityVarDecl != null && !(this.entityVarDecl.getDeclType() instanceof NodeTypeNode) && !(this.entityVarDecl.getDeclType() instanceof EdgeTypeNode)) {
            this.reportError("The variable in a typeof (" + this.entityUnresolved + ") must be of node or edge type, but is of type " + this.entityVarDecl.getDeclType().getTypeName() + " (which is a " + this.entityVarDecl.getDeclType().getKind() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        Entity entity = ((DeclNode)this.getValidResolvedVersion(this.entityEdgeDecl, this.entityNodeDecl, this.entityVarDecl)).checkIR(Entity.class);
        return new Typeof(entity);
    }

    public DeclNode getEntity() {
        assert (this.isResolved());
        return this.getValidResolvedVersion(this.entityEdgeDecl, this.entityNodeDecl, this.entityVarDecl);
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.typeType;
    }

    @Override
    public boolean noDefElement(String string) {
        if (this.entityEdgeDecl != null && this.entityEdgeDecl.defEntityToBeYieldedTo) {
            this.entityEdgeDecl.reportError("A def edge (" + this.entityUnresolved + ") cannot be accessed from a(n) " + string + ".");
            return false;
        }
        if (this.entityNodeDecl != null && this.entityNodeDecl.defEntityToBeYieldedTo) {
            this.entityNodeDecl.reportError("A def node (" + this.entityUnresolved + ") cannot be accessed from a(n) " + string + ".");
            return false;
        }
        if (this.entityVarDecl != null && this.entityVarDecl.defEntityToBeYieldedTo && !this.entityVarDecl.lambdaExpressionVariable) {
            this.entityVarDecl.reportError("A def variable (" + this.entityUnresolved + ") cannot be accessed from a(n) " + string + ".");
            return false;
        }
        return true;
    }

    static {
        TypeofNode.setName(TypeofNode.class, "typeof");
        entityResolver = new DeclarationTripleResolver<EdgeDeclNode, NodeDeclNode, VarDeclNode>(EdgeDeclNode.class, NodeDeclNode.class, VarDeclNode.class);
    }
}

