/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.DeclaredCharacter;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.ScopeOwner;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class QualIdentNode
extends BaseNode
implements DeclaredCharacter {
    protected IdentNode ownerUnresolved;
    private DeclNode owner;
    protected IdentNode memberUnresolved;
    private DeclNode member;
    private static final DeclarationResolver<DeclNode> ownerResolver;
    private static final DeclarationResolver<MemberDeclNode> memberResolver;

    public QualIdentNode(Coords coords, IdentNode identNode, IdentNode identNode2) {
        super(coords);
        this.ownerUnresolved = identNode;
        this.ownerUnresolved.getCoords();
        this.becomeParent(this.ownerUnresolved);
        this.memberUnresolved = identNode2;
        this.becomeParent(this.memberUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.ownerUnresolved, this.owner));
        vector.add(this.getValidVersion(this.memberUnresolved, this.member));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("owner");
        vector.add("member");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl;
        boolean bl2 = QualIdentNode.fixupDefinition(this.ownerUnresolved, this.ownerUnresolved.getScope());
        if (!bl2) {
            return false;
        }
        boolean bl3 = true;
        this.owner = (DeclNode)ownerResolver.resolve(this.ownerUnresolved, this);
        bl3 = this.owner != null && bl3;
        boolean bl4 = bl = this.owner != null && this.owner.resolve();
        if (!bl) {
            return false;
        }
        TypeNode typeNode = this.owner.getDeclType();
        if (this.owner instanceof NodeDeclNode || this.owner instanceof EdgeDeclNode) {
            if (typeNode instanceof ScopeOwner) {
                ScopeOwner scopeOwner = (ScopeOwner)((Object)typeNode);
                scopeOwner.fixupDefinition(this.memberUnresolved);
                this.member = (DeclNode)memberResolver.resolve(this.memberUnresolved, this);
                bl3 = this.member != null && bl3;
            } else {
                this.reportError("Left hand side of '.' does not own a scope (in " + this + ").");
                bl3 = false;
            }
        } else if (this.owner instanceof VarDeclNode) {
            this.member = Resolver.resolveMember(typeNode, this.memberUnresolved);
            if (this.member == null) {
                bl3 = false;
            }
        } else {
            this.reportError("Left hand side of '.' is neither a node nor an edge, nor a variable (in " + this + ").");
            bl3 = false;
        }
        return bl3;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public MemberDeclNode getDecl() {
        assert (this.isResolved());
        return this.member instanceof MemberDeclNode ? (MemberDeclNode)this.member : null;
    }

    public DeclNode getOwner() {
        assert (this.isResolved());
        return this.owner;
    }

    public boolean isMatchAssignment() {
        assert (this.isResolved());
        return !(this.member instanceof MemberDeclNode);
    }

    public boolean isTransientObjectAssignment() {
        assert (this.isResolved());
        return this.owner.getDeclType() instanceof InternalTransientObjectTypeNode;
    }

    public DeclNode getMember() {
        assert (this.isResolved());
        return this.member;
    }

    @Override
    protected IR constructIR() {
        Entity entity = this.owner.checkIR(Entity.class);
        Entity entity2 = this.member.checkIR(Entity.class);
        return new Qualification(entity, entity2);
    }

    public static String getKindStr() {
        return "qualified identifier";
    }

    @Override
    public String toString() {
        return this.ownerUnresolved + "." + this.memberUnresolved;
    }

    static {
        QualIdentNode.setName(QualIdentNode.class, "Qualification");
        ownerResolver = new DeclarationResolver<DeclNode>(DeclNode.class);
        memberResolver = new DeclarationResolver<MemberDeclNode>(MemberDeclNode.class);
    }
}

