/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Constant;
import de.unika.ipd.grgen.parser.Coords;

public class NullConstNode
extends ConstNode {
    private TypeNode type = BasicTypeNode.nullType;

    public NullConstNode(Coords coords) {
        super(coords, "null", Value.NULL);
    }

    @Override
    public TypeNode getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "Const (" + this.type + ") null";
    }

    @Override
    protected IR constructIR() {
        return new Constant(this.getType().getType(), null);
    }

    @Override
    protected ConstNode doCastTo(TypeNode typeNode) {
        NullConstNode nullConstNode = new NullConstNode(this.getCoords());
        nullConstNode.type = typeNode;
        return nullConstNode;
    }

    public static class Value {
        public static Value NULL = new Value(){

            public String toString() {
                return "Const null";
            }
        };

        private Value() {
        }
    }
}

