/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.TypeofNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.UntypedExecVarTypeNode;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.GraphEntityExpression;
import de.unika.ipd.grgen.ir.expr.MatchAccess;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.expr.VariableExpression;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MemberAccessExprNode
extends ExprNode {
    private ExprNode targetExpr;
    private IdentNode memberIdent;
    private DeclNode member;

    public MemberAccessExprNode(Coords coords, ExprNode exprNode, IdentNode identNode) {
        super(coords);
        this.targetExpr = this.becomeParent(exprNode);
        this.memberIdent = this.becomeParent(identNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        if (this.isResolved() && this.resolutionResult() && this.targetExpr.getType() instanceof MatchTypeNode) {
            return vector;
        }
        vector.add(this.targetExpr);
        vector.add(this.memberIdent);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("targetExpr");
        vector.add("memberIdent");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        BaseNode baseNode;
        if (!this.targetExpr.resolve()) {
            return false;
        }
        if (this.targetExpr instanceof IdentExprNode) {
            baseNode = (IdentExprNode)this.targetExpr;
            if (((IdentExprNode)baseNode).decl instanceof TypeDeclNode) {
                TypeDeclNode typeDeclNode = (TypeDeclNode)((IdentExprNode)baseNode).decl;
                this.reportError("Member access expects an entity, but is given a type (unexpected " + typeDeclNode.getIdentNode() + " when accessing " + this.memberIdent + ").");
            }
        }
        if (this.targetExpr instanceof TypeofNode) {
            baseNode = (TypeofNode)this.targetExpr;
            this.reportError("Member access expects an entity, but is given a type (unexpected typeof(" + ((TypeofNode)baseNode).getEntity().getDecl().getIdentNode() + ") when accessing " + this.memberIdent + ").");
        }
        if ((baseNode = this.targetExpr.getType()) instanceof UntypedExecVarTypeNode) {
            this.member = new MemberDeclNode(this.memberIdent, BasicTypeNode.untypedType, false);
            this.member.resolve();
            this.setCheckVisited();
            return true;
        }
        this.member = Resolver.resolveMember((TypeNode)baseNode, this.memberIdent);
        return this.member != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    public final ExprNode getTarget() {
        return this.targetExpr;
    }

    public final MemberDeclNode getDecl() {
        assert (this.isResolved());
        return this.member instanceof MemberDeclNode ? (MemberDeclNode)this.member : null;
    }

    @Override
    public TypeNode getType() {
        TypeNode typeNode = null;
        typeNode = this.targetExpr.getType() instanceof MatchTypeNode ? this.member.getDeclType() : this.member.getDecl().getDeclType();
        return typeNode;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        if (this.targetExpr.getType() instanceof MatchTypeNode) {
            return new MatchAccess(this.targetExpr.checkIR(Expression.class), this.member.checkIR(Entity.class));
        }
        if (this.targetExpr.getIR() instanceof VariableExpression) {
            return new Qualification(this.targetExpr.checkIR(VariableExpression.class).getVariable(), this.member.checkIR(Entity.class));
        }
        if (this.targetExpr.getIR() instanceof GraphEntityExpression) {
            return new Qualification(this.targetExpr.checkIR(GraphEntityExpression.class).getGraphEntity(), this.member.checkIR(Entity.class));
        }
        return new Qualification(this.targetExpr.checkIR(Expression.class), this.member.checkIR(Entity.class));
    }

    public static String getKindStr() {
        return "member";
    }

    static {
        MemberAccessExprNode.setName(MemberAccessExprNode.class, "member access expression");
    }
}

