/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.IteratedQueryExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class IteratedQueryExprNode
extends ExprNode {
    private IdentNode iteratedUnresolved;
    private IteratedDeclNode iterated;
    private TypeNode arrayOfMatchTypeUnresolved;
    private TypeNode arrayOfMatchType;
    private static final DeclarationResolver<IteratedDeclNode> iteratedResolver;

    public IteratedQueryExprNode(Coords coords, IdentNode identNode, TypeNode typeNode) {
        super(coords);
        this.iteratedUnresolved = this.becomeParent(identNode);
        this.arrayOfMatchTypeUnresolved = this.becomeParent(typeNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.iteratedUnresolved, this.iterated));
        vector.add(this.getValidVersion(this.arrayOfMatchTypeUnresolved, this.arrayOfMatchType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("iterated");
        vector.add("arrayOfMatchType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.iterated = (IteratedDeclNode)iteratedResolver.resolve(this.iteratedUnresolved, this);
        if (this.iterated == null) {
            return false;
        }
        if (this.arrayOfMatchTypeUnresolved.resolve()) {
            this.arrayOfMatchType = this.arrayOfMatchTypeUnresolved;
        }
        return this.arrayOfMatchType != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    protected IR constructIR() {
        return new IteratedQueryExpr(this.iteratedUnresolved.getIdent(), this.iterated.checkIR(Rule.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.arrayOfMatchType;
    }

    @Override
    public boolean noIteratedReference(String string) {
        this.reportError("The matches of an iterated cannot be accessed with an iterated query [?" + this.iteratedUnresolved + "] from a " + string + ", only from a yield block or yield expression or eval.");
        return false;
    }

    @Override
    public boolean iteratedNotReferenced(String string) {
        if (this.iterated.getIdentNode().toString().equals(string)) {
            this.reportError("An iterated query cannot access an iterated it is contained in, as it occurs with [?" + this.iteratedUnresolved + "].");
            return false;
        }
        return true;
    }

    static {
        IteratedQueryExprNode.setName(IteratedQueryExprNode.class, "iterated query");
        iteratedResolver = new DeclarationResolver<IteratedDeclNode>(IteratedDeclNode.class);
    }
}

