/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.Count;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class CountNode
extends ExprNode {
    private IdentNode iteratedUnresolved;
    private IteratedDeclNode iterated;
    private static final DeclarationResolver<IteratedDeclNode> iteratedResolver;

    public CountNode(Coords coords, IdentNode identNode) {
        super(coords);
        this.iteratedUnresolved = identNode;
        this.becomeParent(this.iteratedUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.iteratedUnresolved, this.iterated));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("iterated");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = CountNode.fixupDefinition(this.iteratedUnresolved, this.iteratedUnresolved.getScope());
        this.iterated = (IteratedDeclNode)iteratedResolver.resolve(this.iteratedUnresolved, this);
        return bl && this.iterated != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    protected IR constructIR() {
        return new Count(this.iterated.checkIR(Rule.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.intType;
    }

    @Override
    public boolean noIteratedReference(String string) {
        this.reportError("The matches of an iterated cannot be accessed with a count(" + this.iteratedUnresolved + ") from a " + string + ", only from a yield block or yield expression or eval.");
        return false;
    }

    @Override
    public boolean iteratedNotReferenced(String string) {
        if (this.iterated.getIdentNode().toString().equals(string)) {
            this.reportError("A count of iterated matches cannot access an iterated it is contained in, as it occurs with count(" + this.iteratedUnresolved + ").");
            return false;
        }
        return true;
    }

    static {
        CountNode.setName(CountNode.class, "count");
        iteratedResolver = new DeclarationResolver<IteratedDeclNode>(IteratedDeclNode.class);
    }
}

