/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.GraphTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ObjectTypeNode;
import de.unika.ipd.grgen.ast.type.container.ContainerTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.CopyExpr;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class CopyExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode sourceExpr;
    private boolean deep;

    public CopyExprNode(Coords coords, ExprNode exprNode, boolean bl) {
        super(coords);
        this.sourceExpr = exprNode;
        this.becomeParent(this.sourceExpr);
        this.deep = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.sourceExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("source expression");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.sourceExpr.getType();
        if (this.deep) {
            if (!(typeNode instanceof GraphTypeNode || typeNode instanceof ContainerTypeNode || typeNode instanceof InternalObjectTypeNode || typeNode instanceof InternalTransientObjectTypeNode || typeNode instanceof ExternalObjectTypeNode || typeNode instanceof ObjectTypeNode)) {
                this.sourceExpr.reportError("The copy construct expects as argument a value of type container or graph or class object or transient class object or external object (but is given a value of " + typeNode.getKind() + " " + typeNode.getTypeName() + ").");
                return false;
            }
        } else if (!(typeNode instanceof MatchTypeNode || typeNode instanceof ContainerTypeNode || typeNode instanceof InternalObjectTypeNode || typeNode instanceof InternalTransientObjectTypeNode || typeNode instanceof ExternalObjectTypeNode || typeNode instanceof ObjectTypeNode)) {
            this.sourceExpr.reportError("The clone construct expects as argument a value of type container or match or class object or transient class object or external object (but is given a value of " + typeNode.getKind() + " " + typeNode.getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.sourceExpr = this.sourceExpr.evaluate();
        return new CopyExpr(this.sourceExpr.checkIR(Expression.class), this.getType().getType(), this.deep);
    }

    @Override
    public TypeNode getType() {
        if (this.sourceExpr.getType() instanceof MatchTypeNode || this.sourceExpr.getType() instanceof ContainerTypeNode || this.sourceExpr.getType() instanceof InternalObjectTypeNode || this.sourceExpr.getType() instanceof InternalTransientObjectTypeNode || this.sourceExpr.getType() instanceof ExternalObjectTypeNode || this.sourceExpr.getType() instanceof ObjectTypeNode) {
            return this.sourceExpr.getType();
        }
        return BasicTypeNode.graphType;
    }

    static {
        CopyExprNode.setName(CopyExprNode.class, "copy expr");
    }
}

