/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.InvalidConstNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.ObjectTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Cast;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class CastNode
extends ExprNode {
    private BaseNode typeUnresolved;
    private TypeNode type;
    private ExprNode expr;
    private static DeclarationTypeResolver<TypeNode> typeResolver;

    public CastNode(Coords coords) {
        super(coords);
    }

    public CastNode(Coords coords, BaseNode baseNode, ExprNode exprNode) {
        super(coords);
        this.typeUnresolved = baseNode;
        this.becomeParent(this.typeUnresolved);
        this.expr = exprNode;
        this.becomeParent(this.expr);
    }

    public CastNode(Coords coords, TypeNode typeNode, ExprNode exprNode, BaseNode baseNode) {
        this(coords, typeNode, exprNode);
        baseNode.becomeParent(this);
        this.resolve();
        this.check();
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.expr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("type");
        vector.add("expr");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        if (this.typeUnresolved instanceof PackageIdentNode) {
            Resolver.resolveOwner((PackageIdentNode)this.typeUnresolved);
        } else {
            CastNode.fixupDefinition(this.typeUnresolved, this.typeUnresolved.getScope());
        }
        this.type = (TypeNode)typeResolver.resolve(this.typeUnresolved, this);
        bl = this.type != null && bl;
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        return this.typeCheckLocal();
    }

    private boolean typeCheckLocal() {
        boolean bl;
        boolean bl2;
        HashSet<TypeNode> hashSet;
        HashSet<TypeNode> hashSet2;
        TypeNode typeNode = this.expr.getType();
        if (typeNode instanceof NodeTypeNode && this.type instanceof NodeTypeNode || typeNode instanceof EdgeTypeNode && this.type instanceof EdgeTypeNode || typeNode instanceof InternalObjectTypeNode && this.type instanceof InternalObjectTypeNode || typeNode instanceof InternalTransientObjectTypeNode && this.type instanceof InternalTransientObjectTypeNode) {
            hashSet2 = new HashSet<TypeNode>();
            ((InheritanceTypeNode)typeNode).doGetCompatibleToTypes(hashSet2);
            hashSet = new HashSet<TypeNode>();
            ((InheritanceTypeNode)this.type).doGetCompatibleToTypes(hashSet);
            boolean bl3 = bl2 = typeNode.equals(this.type) || hashSet2.contains(this.type) || hashSet.contains(typeNode);
            if (bl2) {
                return true;
            }
        }
        if (typeNode instanceof ObjectTypeNode) {
            return true;
        }
        if (this.type instanceof ObjectTypeNode) {
            return true;
        }
        if (typeNode instanceof ExternalObjectTypeNode && this.type instanceof ExternalObjectTypeNode) {
            hashSet2 = new HashSet();
            ((ExternalObjectTypeNode)typeNode).doGetCompatibleToTypes(hashSet2);
            hashSet = new HashSet();
            ((ExternalObjectTypeNode)this.type).doGetCompatibleToTypes(hashSet);
            boolean bl4 = bl2 = typeNode.equals(this.type) || hashSet2.contains(this.type) || hashSet.contains(typeNode);
            if (bl2) {
                return true;
            }
        }
        if (!(bl = typeNode.isCastableTo(this.type))) {
            this.reportError("A cast from " + this.expr.getType().toStringWithDeclarationCoords() + " to " + this.type.toStringWithDeclarationCoords() + " is not supported.");
        }
        return bl;
    }

    @Override
    public ExprNode evaluate() {
        assert (this.isResolved());
        this.expr = this.expr.evaluate();
        if (this.expr instanceof ConstNode) {
            ConstNode constNode = ((ConstNode)this.expr).castTo(this.type);
            if (constNode instanceof InvalidConstNode) {
                this.reportError("The cast from " + this.expr.toString() + " of type " + this.expr.getType().toStringWithDeclarationCoords() + " to type " + this.type.toStringWithDeclarationCoords() + " is failing.");
                return this;
            }
            return constNode;
        }
        return this;
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.type;
    }

    @Override
    protected IR constructIR() {
        Type type = this.type.checkIR(Type.class);
        this.expr = this.expr.evaluate();
        Expression expression = this.expr.checkIR(Expression.class);
        return new Cast(type, expression);
    }

    static {
        CastNode.setName(CastNode.class, "cast expression");
        typeResolver = new DeclarationTypeResolver<TypeNode>(TypeNode.class);
    }
}

