/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.ObjectInitNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.BaseInternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.AttributeInitialization;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.InternalObjectInit;
import de.unika.ipd.grgen.ir.model.type.BaseInternalObjectType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class AttributeInitializationNode
extends BaseNode {
    public ObjectInitNode objectInit;
    public InternalObjectInit objectInitIR;
    public IdentNode ownerUnresolved;
    public BaseInternalObjectTypeNode owner;
    public IdentNode attributeUnresolved;
    public MemberDeclNode attribute;
    public ExprNode initialization;
    private static final DeclarationTypeResolver<BaseInternalObjectTypeNode> objectTypeResolver = new DeclarationTypeResolver<BaseInternalObjectTypeNode>(BaseInternalObjectTypeNode.class);
    private static final DeclarationResolver<MemberDeclNode> memberResolver = new DeclarationResolver<MemberDeclNode>(MemberDeclNode.class);

    public AttributeInitializationNode(ObjectInitNode objectInitNode, IdentNode identNode, IdentNode identNode2, ExprNode exprNode) {
        this.objectInit = objectInitNode;
        this.ownerUnresolved = identNode;
        this.attributeUnresolved = identNode2;
        this.initialization = exprNode;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.attributeUnresolved, this.attribute));
        vector.add(this.initialization);
        return vector;
    }

    @Override
    protected Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("attribute");
        vector.add("initialization");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.owner = (BaseInternalObjectTypeNode)objectTypeResolver.resolve(this.ownerUnresolved, this);
        if (this.owner == null || !this.owner.resolve()) {
            return false;
        }
        this.owner.fixupDefinition(this.attributeUnresolved);
        this.attribute = (MemberDeclNode)memberResolver.resolve(this.attributeUnresolved, this);
        return this.attribute != null;
    }

    @Override
    protected boolean checkLocal() {
        if (this.attribute.isConst()) {
            this.objectInit.reportError("An assignment to a const member is not allowed (but occurs for " + this.attribute + ").");
            return false;
        }
        if (this.owner.isConst()) {
            this.objectInit.reportError("An assignment to an object of const type is not allowed (but occurs for " + this.attribute + " of " + this.owner.getIdentNode() + ").");
            return false;
        }
        TypeNode typeNode = this.attribute.getDeclType();
        TypeNode typeNode2 = this.initialization.getType();
        if (typeNode2.isEqual(typeNode)) {
            return true;
        }
        this.initialization = this.becomeParent(this.initialization.adjustType(typeNode, this.objectInit.getCoords()));
        if (this.initialization == ConstNode.getInvalid()) {
            return false;
        }
        if (typeNode instanceof NodeTypeNode && typeNode2 instanceof NodeTypeNode || typeNode instanceof EdgeTypeNode && typeNode2 instanceof EdgeTypeNode) {
            HashSet<TypeNode> hashSet = new HashSet<TypeNode>();
            typeNode2.doGetCompatibleToTypes(hashSet);
            if (!hashSet.contains(typeNode)) {
                this.objectInit.reportError("Cannot initialize-assign a value of " + typeNode2.toStringWithDeclarationCoords() + " to an attribute of " + typeNode.toStringWithDeclarationCoords() + " (this occurs for " + this.attribute + ").");
                return false;
            }
        }
        if (typeNode instanceof NodeTypeNode && typeNode2 instanceof EdgeTypeNode || typeNode instanceof EdgeTypeNode && typeNode2 instanceof NodeTypeNode) {
            this.objectInit.reportError("Cannot initialize-assign a value of " + typeNode2.toStringWithDeclarationCoords() + " to an attribute of " + typeNode.toStringWithDeclarationCoords() + " (this occurs for " + this.attribute + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        AttributeInitialization attributeInitialization = new AttributeInitialization();
        this.setIR(attributeInitialization);
        assert (this.objectInitIR != null);
        attributeInitialization.init = this.objectInitIR;
        attributeInitialization.owner = this.owner.checkIR(BaseInternalObjectType.class);
        attributeInitialization.attribute = this.attribute.checkIR(Entity.class);
        this.initialization = this.initialization.evaluate();
        attributeInitialization.expr = this.initialization.checkIR(Expression.class);
        return attributeInitialization;
    }
}

