/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr;

import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.ExprPairNode;
import de.unika.ipd.grgen.ast.expr.OperatorNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.expr.map.MapInitNode;
import de.unika.ipd.grgen.ast.expr.set.SetInitNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.IndexedAccessExpr;
import de.unika.ipd.grgen.ir.expr.Operator;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.map.MapAddItem;
import de.unika.ipd.grgen.ir.stmt.map.MapRemoveItem;
import de.unika.ipd.grgen.ir.stmt.set.SetAddItem;
import de.unika.ipd.grgen.ir.stmt.set.SetRemoveItem;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import de.unika.ipd.grgen.ir.type.container.DequeType;
import de.unika.ipd.grgen.ir.type.container.MapType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ArithmeticOperatorNode
extends OperatorNode {
    private static Map<OperatorDeclNode.Operator, Operator.OperatorCode> irOpCodeMap;
    private QualIdentNode target = null;

    public ArithmeticOperatorNode(Coords coords, OperatorDeclNode.Operator operator) {
        super(coords, operator);
    }

    public ArithmeticOperatorNode(Coords coords, OperatorDeclNode.Operator operator, ExprNode exprNode, ExprNode exprNode2) {
        super(coords, operator);
        this.children.add(exprNode);
        this.children.add(exprNode2);
    }

    public Vector<ExprNode> getChildren() {
        return this.children;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    public ExprNode evaluate() {
        int n = this.children.size();
        ExprNode[] exprNodeArray = new ExprNode[n];
        for (int i = 0; i < n; ++i) {
            ExprNode exprNode = (ExprNode)this.children.get(i);
            exprNodeArray[i] = exprNode.evaluate();
            this.children.set(i, exprNodeArray[i]);
        }
        return this.getOperatorDecl().evaluate(this, exprNodeArray);
    }

    public void markToBreakUpIntoStateChangingOperations(QualIdentNode qualIdentNode) {
        this.target = qualIdentNode;
    }

    @Override
    protected IR constructIR() {
        if (this.target != null) {
            Qualification qualification = this.target.checkIR(Qualification.class);
            EvalStatement evalStatement = null;
            EvalStatement evalStatement2 = null;
            if (((ExprNode)this.children.get(0)).getIR() instanceof EvalStatement) {
                evalStatement = evalStatement2 = ((ExprNode)this.children.get(0)).checkIR(EvalStatement.class);
                while (evalStatement.getNext() != null) {
                    evalStatement = evalStatement.getNext();
                }
            }
            evalStatement2 = this.replaceSetMapOrExceptByAddRemove(qualification, evalStatement, evalStatement2);
            return evalStatement2;
        }
        if (this.getOperatorDecl().getOperator() == OperatorDeclNode.Operator.INDEX) {
            Expression expression = ((ExprNode)this.children.get(0)).checkIR(Expression.class);
            Type type = expression.getType();
            Type type2 = type instanceof MapType ? ((MapType)type).getValueType() : (type instanceof DequeType ? ((DequeType)type).getValueType() : (type instanceof ArrayType ? ((ArrayType)type).getValueType() : type));
            return new IndexedAccessExpr(expression, ((ExprNode)this.children.get(1)).checkIR(Expression.class), type2);
        }
        DeclaredTypeNode declaredTypeNode = (DeclaredTypeNode)this.getType();
        Operator operator = new Operator(declaredTypeNode.getType(), ArithmeticOperatorNode.getIROpCode(this.getOperator()));
        for (ExprNode exprNode : this.children) {
            Expression expression = exprNode.checkIR(Expression.class);
            operator.addOperand(expression);
        }
        return operator;
    }

    private EvalStatement replaceSetMapOrExceptByAddRemove(Qualification qualification, EvalStatement evalStatement, EvalStatement evalStatement2) {
        if (this.getOperatorDecl().getOperator() == OperatorDeclNode.Operator.BIT_OR) {
            if (((ExprNode)this.children.get(1)).getType() instanceof SetTypeNode) {
                SetInitNode setInitNode = (SetInitNode)this.children.get(1);
                for (ExprNode exprNode : setInitNode.getItems().getChildren()) {
                    SetAddItem setAddItem = new SetAddItem(qualification, exprNode.checkIR(Expression.class));
                    if (evalStatement2 == null) {
                        evalStatement2 = setAddItem;
                    }
                    if (evalStatement != null) {
                        evalStatement.setNext(setAddItem);
                    }
                    evalStatement = setAddItem;
                }
            } else {
                MapInitNode mapInitNode = (MapInitNode)this.children.get(1);
                for (ExprPairNode exprPairNode : mapInitNode.getItems().getChildren()) {
                    MapAddItem mapAddItem = new MapAddItem(qualification, exprPairNode.keyExpr.checkIR(Expression.class), exprPairNode.valueExpr.checkIR(Expression.class));
                    if (evalStatement2 == null) {
                        evalStatement2 = mapAddItem;
                    }
                    if (evalStatement != null) {
                        evalStatement.setNext(mapAddItem);
                    }
                    evalStatement = mapAddItem;
                }
            }
        } else if (((ExprNode)this.children.get(1)).getType() instanceof SetTypeNode) {
            SetInitNode setInitNode = (SetInitNode)this.children.get(1);
            if (((ExprNode)this.children.get(0)).getType() instanceof MapTypeNode) {
                for (ExprNode exprNode : setInitNode.getItems().getChildren()) {
                    MapRemoveItem mapRemoveItem = new MapRemoveItem(qualification, exprNode.checkIR(Expression.class));
                    if (evalStatement2 == null) {
                        evalStatement2 = mapRemoveItem;
                    }
                    if (evalStatement != null) {
                        evalStatement.setNext(mapRemoveItem);
                    }
                    evalStatement = mapRemoveItem;
                }
            } else {
                for (ExprNode exprNode : setInitNode.getItems().getChildren()) {
                    SetRemoveItem setRemoveItem = new SetRemoveItem(qualification, exprNode.checkIR(Expression.class));
                    if (evalStatement2 == null) {
                        evalStatement2 = setRemoveItem;
                    }
                    if (evalStatement != null) {
                        evalStatement.setNext(setRemoveItem);
                    }
                    evalStatement = setRemoveItem;
                }
            }
        } else {
            MapInitNode mapInitNode = (MapInitNode)this.children.get(1);
            for (ExprPairNode exprPairNode : mapInitNode.getItems().getChildren()) {
                MapRemoveItem mapRemoveItem = new MapRemoveItem(qualification, exprPairNode.keyExpr.checkIR(Expression.class));
                if (evalStatement2 == null) {
                    evalStatement2 = mapRemoveItem;
                }
                if (evalStatement != null) {
                    evalStatement.setNext(mapRemoveItem);
                }
                evalStatement = mapRemoveItem;
            }
        }
        return evalStatement2;
    }

    private static void assocOpCode(OperatorDeclNode.Operator operator, Operator.OperatorCode operatorCode) {
        irOpCodeMap.put(operator, operatorCode);
    }

    private static Operator.OperatorCode getIROpCode(OperatorDeclNode.Operator operator) {
        return irOpCodeMap.get((Object)operator);
    }

    @Override
    public String toString() {
        return OperatorDeclNode.getName(this.getOperator());
    }

    static {
        ArithmeticOperatorNode.setName(ArithmeticOperatorNode.class, "arithmetic operator");
        irOpCodeMap = new HashMap<OperatorDeclNode.Operator, Operator.OperatorCode>();
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.COND, Operator.OperatorCode.COND);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.LOG_OR, Operator.OperatorCode.LOG_OR);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.LOG_AND, Operator.OperatorCode.LOG_AND);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.BIT_OR, Operator.OperatorCode.BIT_OR);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.BIT_XOR, Operator.OperatorCode.BIT_XOR);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.BIT_AND, Operator.OperatorCode.BIT_AND);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.EQ, Operator.OperatorCode.EQ);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.NE, Operator.OperatorCode.NE);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.SE, Operator.OperatorCode.SE);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.LT, Operator.OperatorCode.LT);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.LE, Operator.OperatorCode.LE);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.GT, Operator.OperatorCode.GT);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.GE, Operator.OperatorCode.GE);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.SHL, Operator.OperatorCode.SHL);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.SHR, Operator.OperatorCode.SHR);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.BIT_SHR, Operator.OperatorCode.BIT_SHR);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.ADD, Operator.OperatorCode.ADD);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.SUB, Operator.OperatorCode.SUB);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.MUL, Operator.OperatorCode.MUL);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.DIV, Operator.OperatorCode.DIV);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.MOD, Operator.OperatorCode.MOD);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.LOG_NOT, Operator.OperatorCode.LOG_NOT);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.BIT_NOT, Operator.OperatorCode.BIT_NOT);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.NEG, Operator.OperatorCode.NEG);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.IN, Operator.OperatorCode.IN);
        ArithmeticOperatorNode.assocOpCode(OperatorDeclNode.Operator.EXCEPT, Operator.OperatorCode.EXCEPT);
    }
}

