/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeTypeChangeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphRhsNode;
import de.unika.ipd.grgen.ast.type.RhsTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.Emit;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.OrderedReplacement;
import de.unika.ipd.grgen.ir.pattern.OrderedReplacements;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public abstract class RhsDeclNode
extends DeclNode {
    public PatternGraphRhsNode patternGraph;
    protected RhsTypeNode type;
    protected static final TypeNode rhsType;
    private Set<ConstraintDeclNode> elementsToDelete;
    private Set<NodeDeclNode> nodesToReuse;
    private Set<ConnectionNode> connectionsToReuse;
    protected static final DeclarationTypeResolver<RhsTypeNode> typeResolver;

    protected RhsDeclNode(IdentNode identNode, PatternGraphRhsNode patternGraphRhsNode) {
        super(identNode, rhsType);
        this.patternGraph = patternGraphRhsNode;
        this.becomeParent(this.patternGraph);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.patternGraph);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("right");
        return vector;
    }

    public PatternGraphRhsNode getRhsGraph() {
        return this.patternGraph;
    }

    public Set<ConstraintDeclNode> getMaybeDeletedElements(PatternGraphLhsNode patternGraphLhsNode) {
        LinkedHashSet<ConstraintDeclNode> linkedHashSet = new LinkedHashSet<ConstraintDeclNode>();
        linkedHashSet.addAll(this.getElementsToDelete(patternGraphLhsNode));
        LinkedHashSet<NodeDeclNode> linkedHashSet2 = new LinkedHashSet<NodeDeclNode>();
        for (ConstraintDeclNode object2 : linkedHashSet) {
            if (!(object2 instanceof NodeDeclNode)) continue;
            linkedHashSet2.add((NodeDeclNode)object2);
        }
        for (NodeDeclNode nodeDeclNode : linkedHashSet2) {
            linkedHashSet.addAll(patternGraphLhsNode.getHomomorphic(nodeDeclNode));
        }
        if (linkedHashSet2.size() > 0) {
            linkedHashSet.addAll(this.getMaybeDeletedEdgesResultingFromMaybeDeletedNodes(linkedHashSet, patternGraphLhsNode));
        }
        LinkedHashSet linkedHashSet3 = new LinkedHashSet();
        for (ConstraintDeclNode constraintDeclNode : linkedHashSet) {
            if (!(constraintDeclNode instanceof EdgeDeclNode)) continue;
            linkedHashSet3.add((EdgeDeclNode)constraintDeclNode);
        }
        Iterator iterator = linkedHashSet3.iterator();
        while (iterator.hasNext()) {
            ConstraintDeclNode constraintDeclNode;
            constraintDeclNode = (EdgeDeclNode)iterator.next();
            linkedHashSet.addAll(patternGraphLhsNode.getHomomorphic((EdgeDeclNode)constraintDeclNode));
        }
        return linkedHashSet;
    }

    private Set<ConstraintDeclNode> getMaybeDeletedEdgesResultingFromMaybeDeletedNodes(Set<ConstraintDeclNode> set, PatternGraphLhsNode patternGraphLhsNode) {
        HashSet<ConstraintDeclNode> hashSet = new HashSet<ConstraintDeclNode>();
        Set<ConnectionNode> set2 = this.getConnectionsNotDeleted(patternGraphLhsNode);
        for (ConnectionNode connectionNode : set2) {
            if (!RhsDeclNode.sourceOrTargetNodeIncluded(connectionNode.getEdge(), patternGraphLhsNode, set)) continue;
            hashSet.add(connectionNode.getEdge());
        }
        for (ConnectionNode connectionNode : set2) {
            EdgeDeclNode edgeDeclNode = connectionNode.getEdge();
            while (edgeDeclNode instanceof EdgeTypeChangeDeclNode) {
                edgeDeclNode = ((EdgeTypeChangeDeclNode)edgeDeclNode).getOldEdge();
            }
            boolean bl = true;
            boolean bl2 = true;
            for (ConnectionNode connectionNode2 : set2) {
                if (!edgeDeclNode.equals(connectionNode2.getEdge())) continue;
                bl &= connectionNode2.getSrc().isDummy();
                bl2 &= connectionNode2.getTgt().isDummy();
            }
            if (!bl && !bl2) continue;
            hashSet.add(edgeDeclNode);
        }
        return hashSet;
    }

    protected abstract Set<ConnectionNode> getConnectionsNotDeleted(PatternGraphLhsNode var1);

    @Override
    protected boolean resolveLocal() {
        this.type = (RhsTypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.type != null;
    }

    private boolean checkEdgeParameters() {
        boolean bl = true;
        for (DeclNode declNode : this.patternGraph.getParamDecls()) {
            if (!(declNode instanceof EdgeDeclNode)) continue;
            declNode.reportError("Edges are not supported as rewrite parameters (but the rewrite parameter " + declNode.getIdentNode() + " is an edge).");
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        return this.checkEdgeParameters();
    }

    public abstract boolean checkAgainstLhsPattern(PatternGraphLhsNode var1);

    @Override
    protected IR constructIR() {
        assert (false);
        return null;
    }

    protected void insertElementsFromEvalsIntoRhs(PatternGraphLhs patternGraphLhs, PatternGraphRhs patternGraphRhs) {
        NeededEntities neededEntities = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.VARS));
        Collection<EvalStatements> collection = this.patternGraph.getEvalStatements();
        for (EvalStatements iR : collection) {
            iR.collectNeededEntities(neededEntities);
        }
        for (Node node : neededEntities.nodes) {
            if (node.directlyNestingLHSGraph == patternGraphLhs || patternGraphRhs.getDeletedElements().contains(node) || patternGraphRhs.hasNode(node)) continue;
            patternGraphRhs.addSingleNode(node);
            patternGraphRhs.addHomToAll(node);
        }
        for (Edge edge : neededEntities.edges) {
            if (edge.directlyNestingLHSGraph == patternGraphLhs || patternGraphRhs.getDeletedElements().contains(edge) || patternGraphRhs.hasEdge(edge)) continue;
            patternGraphRhs.addSingleEdge(edge);
            patternGraphRhs.addHomToAll(edge);
        }
        for (Variable variable : neededEntities.variables) {
            if (variable.directlyNestingLHSGraph == patternGraphLhs || patternGraphRhs.hasVar(variable)) continue;
            patternGraphRhs.addVariable(variable);
        }
    }

    protected void insertElementsFromOrderedReplacementsIntoRhs(PatternGraphLhs patternGraphLhs, PatternGraphRhs patternGraphRhs) {
        NeededEntities neededEntities = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.VARS));
        Collection<OrderedReplacements> collection = this.patternGraph.getOrderedReplacements();
        for (OrderedReplacements iR : collection) {
            for (OrderedReplacement orderedReplacement : iR.orderedReplacements) {
                if (orderedReplacement instanceof EvalStatement) {
                    ((EvalStatement)orderedReplacement).collectNeededEntities(neededEntities);
                    continue;
                }
                if (!(orderedReplacement instanceof Emit)) continue;
                ((Emit)orderedReplacement).collectNeededEntities(neededEntities);
            }
        }
        for (Node node : neededEntities.nodes) {
            if (node.directlyNestingLHSGraph == patternGraphLhs || patternGraphRhs.getDeletedElements().contains(node) || patternGraphRhs.hasNode(node)) continue;
            patternGraphRhs.addSingleNode(node);
            patternGraphRhs.addHomToAll(node);
        }
        for (Edge edge : neededEntities.edges) {
            if (edge.directlyNestingLHSGraph == patternGraphLhs || patternGraphRhs.getDeletedElements().contains(edge) || patternGraphRhs.hasEdge(edge)) continue;
            patternGraphRhs.addSingleEdge(edge);
            patternGraphRhs.addHomToAll(edge);
        }
        for (Variable variable : neededEntities.variables) {
            if (variable.directlyNestingLHSGraph == patternGraphLhs || patternGraphRhs.hasVar(variable)) continue;
            patternGraphRhs.addVariable(variable);
        }
    }

    public abstract PatternGraphRhs getPatternGraph(PatternGraphLhs var1);

    @Override
    public RhsTypeNode getDeclType() {
        assert (this.isResolved());
        return this.type;
    }

    public Set<ConstraintDeclNode> getElementsToDelete(PatternGraphLhsNode patternGraphLhsNode) {
        if (this.elementsToDelete == null) {
            this.elementsToDelete = Collections.unmodifiableSet(this.getElementsToDeleteImpl(patternGraphLhsNode));
        }
        return this.elementsToDelete;
    }

    protected abstract Set<ConstraintDeclNode> getElementsToDeleteImpl(PatternGraphLhsNode var1);

    public Set<ConnectionNode> getConnectionsToReuse(PatternGraphLhsNode patternGraphLhsNode) {
        if (this.connectionsToReuse == null) {
            this.connectionsToReuse = Collections.unmodifiableSet(this.getConnectionsToReuseImpl(patternGraphLhsNode));
        }
        return this.connectionsToReuse;
    }

    protected abstract Set<ConnectionNode> getConnectionsToReuseImpl(PatternGraphLhsNode var1);

    public Set<NodeDeclNode> getNodesToReuse(PatternGraphLhsNode patternGraphLhsNode) {
        if (this.nodesToReuse == null) {
            this.nodesToReuse = Collections.unmodifiableSet(this.getNodesToReuseImpl(patternGraphLhsNode));
        }
        return this.nodesToReuse;
    }

    protected abstract Set<NodeDeclNode> getNodesToReuseImpl(PatternGraphLhsNode var1);

    protected static boolean sourceOrTargetNodeIncluded(EdgeDeclNode edgeDeclNode, PatternGraphLhsNode patternGraphLhsNode, Collection<? extends BaseNode> collection) {
        for (ConnectionCharacter connectionCharacter : patternGraphLhsNode.getConnections()) {
            ConnectionNode connectionNode;
            if (!(connectionCharacter instanceof ConnectionNode) || !(connectionNode = (ConnectionNode)connectionCharacter).getEdge().equals(edgeDeclNode) || !collection.contains(connectionNode.getSrc()) && !collection.contains(connectionNode.getTgt())) continue;
            return true;
        }
        return false;
    }

    static {
        RhsDeclNode.setName(RhsDeclNode.class, "right-hand side declaration");
        rhsType = new RhsTypeNode();
        typeResolver = new DeclarationTypeResolver<RhsTypeNode>(RhsTypeNode.class);
    }
}

