/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.pattern.Node;
import java.util.Collection;
import java.util.Vector;

public class NodeInterfaceTypeChangeDeclNode
extends NodeDeclNode {
    private IdentNode interfaceTypeUnresolved;
    public TypeDeclNode interfaceType = null;
    private static final DeclarationResolver<TypeDeclNode> typeResolver;

    public NodeInterfaceTypeChangeDeclNode(IdentNode identNode, BaseNode baseNode, int n, IdentNode identNode2, PatternGraphLhsNode patternGraphLhsNode, boolean bl) {
        super(identNode, baseNode, ConstraintDeclNode.CopyKind.None, n, TypeExprNode.getEmpty(), patternGraphLhsNode, bl, false);
        this.interfaceTypeUnresolved = identNode2;
        this.becomeParent(this.interfaceTypeUnresolved);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeNodeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.getValidVersion(this.interfaceTypeUnresolved, this.interfaceType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("interfaceType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        this.interfaceType = (TypeDeclNode)typeResolver.resolve(this.interfaceTypeUnresolved, this);
        if (this.interfaceType == null) {
            return false;
        }
        if (!this.interfaceType.resolve()) {
            return false;
        }
        if (!(this.interfaceType.getDeclType() instanceof NodeTypeNode)) {
            this.interfaceTypeUnresolved.reportError("The interface type of node parameter " + this.getIdentNode() + " must be a node type (given is " + this.interfaceType.getDeclType().getKind() + " " + this.interfaceType.getDeclType().getTypeName() + " - use -edge-> syntax for edges, var for variables, ref for containers).");
            return false;
        }
        if (!bl) {
            return false;
        }
        NodeTypeNode nodeTypeNode = (NodeTypeNode)this.interfaceType.getDeclType();
        NodeTypeNode nodeTypeNode2 = (NodeTypeNode)this.typeTypeDecl.getDeclType();
        if (!nodeTypeNode2.isA(nodeTypeNode)) {
            this.interfaceTypeUnresolved.reportWarning("The interface type " + nodeTypeNode.toStringWithDeclarationCoords() + " of node parameter " + this.ident.toString() + " is not a supertype of " + nodeTypeNode2.toStringWithDeclarationCoords() + ".");
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        TypeChecker typeChecker = new TypeChecker(NodeTypeNode.class);
        boolean bl = super.checkLocal() & typeChecker.check(this.interfaceType, error);
        if (!bl) {
            return false;
        }
        return bl & this.onlyPatternNodesCanChangeInterfaceType();
    }

    private boolean onlyPatternNodesCanChangeInterfaceType() {
        if ((this.context & 1) == 0) {
            return true;
        }
        this.reportError("Rewrite part node parameters cannot change the interface type, only pattern nodes can (this is violated by " + this.getIdentNode() + ").");
        return false;
    }

    @Override
    protected IR constructIR() {
        Node node = (Node)super.constructIR();
        NodeTypeNode nodeTypeNode = (NodeTypeNode)this.interfaceType.getDeclType();
        NodeType nodeType = nodeTypeNode.getNodeType();
        node.setParameterInterfaceType(nodeType);
        return node;
    }

    static {
        NodeInterfaceTypeChangeDeclNode.setName(NodeInterfaceTypeChangeDeclNode.class, "node interface type change decl");
        typeResolver = new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class);
    }
}

