/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.MatchNodeFromByStorageDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.StorageAccess;
import de.unika.ipd.grgen.ir.pattern.StorageAccessIndex;
import de.unika.ipd.grgen.ir.pattern.Variable;
import java.util.Collection;
import java.util.Vector;

public class MatchNodeByStorageAccessDeclNode
extends MatchNodeFromByStorageDeclNode {
    private IdentExprNode accessorUnresolved;
    private ConstraintDeclNode accessor = null;

    public MatchNodeByStorageAccessDeclNode(IdentNode identNode, BaseNode baseNode, int n, BaseNode baseNode2, IdentExprNode identExprNode, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, baseNode, n, baseNode2, patternGraphLhsNode);
        this.accessorUnresolved = identExprNode;
        this.becomeParent(this.accessorUnresolved);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeNodeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.getValidVersion(this.storageUnresolved, this.storage, this.storageAttribute, this.storageGlobalVariable));
        vector.add(this.getValidVersion(this.accessorUnresolved, this.accessor));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("storage");
        vector.add("accessor");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        if (this.storageUnresolved instanceof IdentExprNode) {
            IdentExprNode identExprNode = (IdentExprNode)this.storageUnresolved;
            if (identExprNode.resolve()) {
                if (identExprNode.decl instanceof VarDeclNode) {
                    this.storage = (VarDeclNode)identExprNode.decl;
                } else if (identExprNode.decl instanceof NodeDeclNode) {
                    this.storageGlobalVariable = (NodeDeclNode)identExprNode.decl;
                } else {
                    this.reportError("Match node by storage access expects a node storage parameter or a node global variable (but" + this.emptyWhenAnonymousPostfix(" ") + " is given neither).");
                    bl = false;
                }
            } else {
                this.reportError("Match node by storage access expects a node storage parameter or a node global variable (but" + this.emptyWhenAnonymousPostfix(" ") + " is given neither).");
                bl = false;
            }
        } else if (this.storageUnresolved instanceof QualIdentNode) {
            QualIdentNode qualIdentNode = (QualIdentNode)this.storageUnresolved;
            if (qualIdentNode.resolve()) {
                this.storageAttribute = qualIdentNode;
            } else {
                this.reportError("Match node by storage attribute access expects a storage attribute (but" + this.emptyWhenAnonymousPostfix(" ") + " is given " + qualIdentNode + ").");
                bl = false;
            }
        } else {
            this.reportError("Internal error - invalid match node by storage attribute (for " + this.getIdentNode() + ").");
            bl = false;
        }
        if (this.accessorUnresolved.resolve() && this.accessorUnresolved.decl instanceof ConstraintDeclNode) {
            this.accessor = (ConstraintDeclNode)this.accessorUnresolved.decl;
        } else {
            this.reportError("Match node by storage access expects a pattern element as accessor (but" + this.emptyWhenAnonymousPostfix(" ") + " is given " + this.accessorUnresolved + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = super.checkLocal();
        if ((this.context & 1) == 1) {
            this.reportError("Cannot employ match node by storage access in the rewrite part (as it occurs in match node" + this.emptyWhenAnonymousPostfix(" ") + " by " + this.getStorageName() + ").");
            return false;
        }
        TypeNode typeNode = this.getStorageType();
        if (!(typeNode instanceof MapTypeNode)) {
            this.reportError("Match node by storage access expects a map type (but" + this.emptyWhenAnonymousPostfix(" ") + " is given " + typeNode.getTypeName() + " by " + this.getStorageName() + ").");
            return false;
        }
        TypeNode typeNode2 = ((MapTypeNode)typeNode).keyType;
        InheritanceTypeNode inheritanceTypeNode = this.accessor.getDeclType();
        if (!inheritanceTypeNode.isCompatibleTo(typeNode2)) {
            String string = typeNode2.toStringWithDeclarationCoords();
            String string2 = inheritanceTypeNode.toStringWithDeclarationCoords();
            this.ident.reportError("Cannot convert " + string2 + " to the expected map key type " + string + " in match node by storage access (" + this.emptyWhenAnonymous("of " + this.getIdentNode() + " ") + "accessing " + this.getStorageName() + ").");
            return false;
        }
        TypeNode typeNode3 = ((MapTypeNode)typeNode).valueType;
        if (!(typeNode3 instanceof NodeTypeNode)) {
            this.reportError("Match node by storage access expects a map mapping to a node type (but" + this.emptyWhenAnonymousPostfix(" ") + " is given a map mapping to " + typeNode3.getKind() + " " + typeNode3.toStringWithDeclarationCoords() + ").");
            return false;
        }
        NodeTypeNode nodeTypeNode = (NodeTypeNode)typeNode3;
        NodeTypeNode nodeTypeNode2 = this.getDeclType();
        if (!nodeTypeNode2.isCompatibleTo(nodeTypeNode)) {
            String string = nodeTypeNode2.toStringWithDeclarationCoords();
            String string3 = nodeTypeNode.toStringWithDeclarationCoords();
            this.ident.reportError("Cannot convert map value type " + string3 + " to the expected pattern element type " + string + " in match node by storage access (" + this.emptyWhenAnonymous("of " + this.getIdentNode() + " ") + "accessing " + this.getStorageName() + ").");
            return false;
        }
        return bl;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Node node = (Node)super.constructIR();
        this.setIR(node);
        if (this.storage != null) {
            node.setStorage(new StorageAccess(this.storage.checkIR(Variable.class)));
        } else if (this.storageAttribute != null) {
            node.setStorage(new StorageAccess(this.storageAttribute.checkIR(Qualification.class)));
        }
        node.setStorageIndex(new StorageAccessIndex(this.accessor.checkIR(GraphEntity.class)));
        return node;
    }

    static {
        MatchNodeByStorageAccessDeclNode.setName(MatchNodeByStorageAccessDeclNode.class, "match node by storage access decl");
    }
}

