/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.MatchNodeByIndexDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.model.Index;
import de.unika.ipd.grgen.ir.pattern.IndexAccessEquality;
import de.unika.ipd.grgen.ir.pattern.Node;
import java.util.Collection;
import java.util.Vector;

public class MatchNodeByIndexAccessEqualityDeclNode
extends MatchNodeByIndexDeclNode {
    private ExprNode expr;

    public MatchNodeByIndexAccessEqualityDeclNode(IdentNode identNode, BaseNode baseNode, int n, IdentNode identNode2, ExprNode exprNode, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, baseNode, n, identNode2, patternGraphLhsNode);
        this.expr = exprNode;
        this.becomeParent(this.expr);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeNodeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.getValidVersion(this.indexUnresolved, this.index));
        vector.add(this.expr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("index");
        vector.add("expression");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        return bl &= this.expr.resolve();
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = super.checkLocal();
        TypeNode typeNode = this.index.getExpectedAccessType();
        TypeNode typeNode2 = this.expr.getType();
        if (!typeNode2.isCompatibleTo(typeNode)) {
            String string = typeNode.getTypeName();
            String string2 = typeNode2.getTypeName();
            this.ident.reportError("Cannot convert type used in accessing index from " + string2 + " to the expected " + string + " (in match node" + this.emptyWhenAnonymousPostfix(" ") + " by index access of " + this.index.toStringWithDeclarationCoords() + ").");
            return false;
        }
        NodeTypeNode nodeTypeNode = this.getDeclType();
        InheritanceTypeNode inheritanceTypeNode = this.index.getType();
        if (!inheritanceTypeNode.isCompatibleTo(nodeTypeNode) && !nodeTypeNode.isCompatibleTo(inheritanceTypeNode)) {
            String string = nodeTypeNode.toStringWithDeclarationCoords();
            String string3 = inheritanceTypeNode.toStringWithDeclarationCoords();
            this.ident.reportError("Cannot convert index type from " + string3 + " to the expected pattern element type " + string + " (in match node" + this.emptyWhenAnonymousPostfix(" ") + " by index access of " + this.index.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return bl;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Node node = (Node)super.constructIR();
        this.setIR(node);
        this.expr = this.expr.evaluate();
        node.setIndex(new IndexAccessEquality(this.index.checkIR(Index.class), this.expr.checkIR(Expression.class)));
        return node;
    }

    static {
        MatchNodeByIndexAccessEqualityDeclNode.setName(MatchNodeByIndexAccessEqualityDeclNode.class, "match node by index access equality decl");
    }
}

