/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.MatchEdgeByIndexDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.model.Index;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.IndexAccessOrdering;
import java.util.Collection;
import java.util.Vector;

public class MatchEdgeByIndexAccessOrderingDeclNode
extends MatchEdgeByIndexDeclNode {
    private boolean ascending;
    private OperatorDeclNode.Operator comp;
    private ExprNode expr;
    private OperatorDeclNode.Operator comp2;
    private ExprNode expr2;

    public MatchEdgeByIndexAccessOrderingDeclNode(IdentNode identNode, BaseNode baseNode, int n, boolean bl, IdentNode identNode2, OperatorDeclNode.Operator operator, ExprNode exprNode, OperatorDeclNode.Operator operator2, ExprNode exprNode2, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, baseNode, n, identNode2, patternGraphLhsNode);
        this.ascending = bl;
        this.comp = operator;
        this.expr = exprNode;
        this.becomeParent(this.expr);
        this.comp2 = operator2;
        this.expr2 = exprNode2;
        this.becomeParent(this.expr);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeEdgeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.getValidVersion(this.indexUnresolved, this.index));
        if (this.expr != null) {
            vector.add(this.expr);
        }
        if (this.expr2 != null) {
            vector.add(this.expr2);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("index");
        if (this.expr != null) {
            vector.add("expression");
        }
        if (this.expr2 != null) {
            vector.add("expression2");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        if (this.expr != null) {
            bl &= this.expr.resolve();
        }
        if (this.expr2 != null) {
            bl &= this.expr2.resolve();
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        String string;
        Object object;
        TypeNode typeNode;
        TypeNode typeNode2;
        boolean bl = super.checkLocal();
        if (this.expr != null) {
            typeNode2 = this.index.getExpectedAccessType();
            typeNode = this.expr.getType();
            if (!typeNode.isCompatibleTo(typeNode2)) {
                object = typeNode2.getTypeName();
                string = typeNode.getTypeName();
                this.expr.reportError("Cannot convert type used in accessing index from " + string + " to the expected " + (String)object + " (in match edge" + this.emptyWhenAnonymousPostfix(" ") + " by index access of " + this.index.toStringWithDeclarationCoords() + ").");
                bl = false;
            }
            if (this.expr2 != null && !((TypeNode)(object = this.expr2.getType())).isCompatibleTo(typeNode2)) {
                string = typeNode2.getTypeName();
                String string2 = ((TypeNode)object).getTypeName();
                this.expr2.reportError("Cannot convert type used in accessing index from " + string2 + " to the expected " + string + " (in match edge" + this.emptyWhenAnonymousPostfix(" ") + " by index access of " + this.index.toStringWithDeclarationCoords() + ").");
                bl = false;
            }
        }
        typeNode2 = this.getDeclType();
        typeNode = this.index.getType();
        if (!typeNode.isCompatibleTo(typeNode2) && !typeNode2.isCompatibleTo(typeNode)) {
            object = typeNode2.toStringWithDeclarationCoords();
            string = typeNode.toStringWithDeclarationCoords();
            this.ident.reportError("Cannot convert index type from " + string + " to the expected pattern element type " + (String)object + " (in match edge" + this.emptyWhenAnonymousPostfix(" ") + " by index access of " + this.index.toStringWithDeclarationCoords() + ").");
            bl = false;
        }
        if (!(this.comp != OperatorDeclNode.Operator.LT && this.comp != OperatorDeclNode.Operator.LE || this.expr2 == null || this.comp2 != OperatorDeclNode.Operator.LT && this.comp2 != OperatorDeclNode.Operator.LE)) {
            this.reportError("Two upper bounds are not supported (in match edge" + this.emptyWhenAnonymousPostfix(" ") + " by index access of " + this.index.getIdentNode() + ").");
            bl = false;
        }
        if (!(this.comp != OperatorDeclNode.Operator.GT && this.comp != OperatorDeclNode.Operator.GE || this.expr2 == null || this.comp2 != OperatorDeclNode.Operator.GT && this.comp2 != OperatorDeclNode.Operator.GE)) {
            this.reportError("Two lower bounds are not supported (in match edge" + this.emptyWhenAnonymousPostfix(" ") + " by index access of " + this.index.getIdentNode() + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Edge edge = (Edge)super.constructIR();
        this.setIR(edge);
        if (this.expr != null) {
            this.expr = this.expr.evaluate();
        }
        if (this.expr2 != null) {
            this.expr2 = this.expr2.evaluate();
        }
        edge.setIndex(new IndexAccessOrdering(this.index.checkIR(Index.class), this.ascending, this.comp, this.expr != null ? this.expr.checkIR(Expression.class) : null, this.comp2, this.expr2 != null ? this.expr2.checkIR(Expression.class) : null));
        return edge;
    }

    static {
        MatchEdgeByIndexAccessOrderingDeclNode.setName(MatchEdgeByIndexAccessOrderingDeclNode.class, "match edge by index access ordering decl");
    }
}

