/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoGeneratedDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoSuppliedDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.NestedMatcherDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.RhsDeclNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.IteratedTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.FilterAutoGenerated;
import de.unika.ipd.grgen.ir.executable.FilterAutoSupplied;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public abstract class IteratedDeclNode
extends NestedMatcherDeclNode {
    protected IteratedTypeNode type;
    protected ArrayList<FilterAutoDeclNode> filters = new ArrayList();
    protected static IteratedTypeNode iteratedType;
    private static final DeclarationTypeResolver<IteratedTypeNode> typeResolver;

    protected IteratedDeclNode(IdentNode identNode, PatternGraphLhsNode patternGraphLhsNode, RhsDeclNode rhsDeclNode) {
        super(identNode, iteratedType, patternGraphLhsNode, rhsDeclNode);
    }

    public void addFilters(ArrayList<FilterAutoDeclNode> arrayList) {
        this.filters.addAll(arrayList);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.pattern);
        if (this.right != null) {
            vector.add(this.right);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("pattern");
        if (this.right != null) {
            vector.add("right");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.type = (IteratedTypeNode)typeResolver.resolve(this.typeUnresolved, this);
        return this.type != null & IteratedDeclNode.resolveFilters(this.filters);
    }

    @Override
    protected boolean checkLocal() {
        return super.checkLocal() & this.checkFilters(this.pattern, this.filters);
    }

    protected abstract int getMinMatches();

    protected abstract int getMaxMatches();

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Rule rule = new Rule(this.getIdentNode().getIdent(), this.getMinMatches(), this.getMaxMatches());
        this.setIR(rule);
        PatternGraphLhs patternGraphLhs = this.pattern.getPatternGraph();
        PatternGraphRhs patternGraphRhs = null;
        if (this.right != null) {
            patternGraphRhs = this.right.getPatternGraph(patternGraphLhs);
        }
        rule.initialize(patternGraphLhs, patternGraphRhs);
        this.constructImplicitNegs(patternGraphLhs);
        this.constructIRaux(rule, this.right);
        for (FilterAutoDeclNode base : this.filters) {
            if (base instanceof FilterAutoSuppliedDeclNode) {
                ((FilterAutoSuppliedDeclNode)base).checkIR(FilterAutoSupplied.class);
                continue;
            }
            ((FilterAutoGeneratedDeclNode)base).checkIR(FilterAutoGenerated.class);
        }
        if (this.right != null) {
            for (EvalStatements evalStatements : this.right.getRhsGraph().getEvalStatements()) {
                rule.addEval(evalStatements);
            }
        }
        return rule;
    }

    @Override
    public IteratedTypeNode getDeclType() {
        assert (this.isResolved());
        return iteratedType;
    }

    public static String getKindStr() {
        return "iterated-cardinality";
    }

    static {
        IteratedDeclNode.setName(IteratedDeclNode.class, "iterated-cardinality");
        iteratedType = new IteratedTypeNode();
        typeResolver = new DeclarationTypeResolver<IteratedTypeNode>(IteratedTypeNode.class);
    }
}

