/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.pattern.NameOrAttributeInitializationNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.RetypedEdge;
import java.util.Collection;
import java.util.Vector;

public class EdgeTypeChangeDeclNode
extends EdgeDeclNode {
    private BaseNode oldUnresolved;
    private EdgeDeclNode old = null;
    private static final DeclarationResolver<EdgeDeclNode> edgeResolver;

    public EdgeTypeChangeDeclNode(IdentNode identNode, BaseNode baseNode, int n, BaseNode baseNode2, PatternGraphLhsNode patternGraphLhsNode) {
        super(identNode, baseNode, ConstraintDeclNode.CopyKind.None, n, TypeExprNode.getEmpty(), patternGraphLhsNode);
        this.oldUnresolved = baseNode2;
        this.becomeParent(this.oldUnresolved);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeEdgeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.getValidVersion(this.oldUnresolved, this.old));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("old");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        this.old = (EdgeDeclNode)edgeResolver.resolve(this.oldUnresolved, this);
        if (this.old != null) {
            this.old.retypedElem = this;
        }
        return bl && this.old != null;
    }

    public final EdgeDeclNode getOldEdge() {
        assert (this.isResolved());
        return this.old;
    }

    @Override
    protected boolean checkLocal() {
        TypeChecker typeChecker = new TypeChecker(EdgeTypeNode.class);
        boolean bl = super.checkLocal() & typeChecker.check(this.old, error);
        if (!bl) {
            return false;
        }
        if (this.nameOrAttributeInits.size() > 0) {
            NameOrAttributeInitializationNode nameOrAttributeInitializationNode = (NameOrAttributeInitializationNode)this.nameOrAttributeInits.get(0);
            if (nameOrAttributeInitializationNode.attributeUnresolved != null) {
                this.reportError("An attribute initialization is not allowed for a retyped edge (but occurs for " + nameOrAttributeInitializationNode.attributeUnresolved + this.emptyWhenAnonymousPostfix(" of ") + ").");
            } else {
                this.reportError("A name initialization ($=) is not allowed for a retyped edge" + this.emptyWhenAnonymous(" (but occurs for " + this.getIdentNode() + ")."));
            }
            return false;
        }
        if ((this.old.context & 1) == 1 && !this.old.defEntityToBeYieldedTo) {
            this.reportError("The original edge of the retyping may not be declared in the rewrite part (this is violated by the original edge " + this.old.getIdentNode() + this.emptyWhenAnonymousPostfix(" of ") + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    protected IR constructIR() {
        EdgeTypeNode edgeTypeNode = this.getDeclType();
        EdgeType edgeType = edgeTypeNode.getEdgeType();
        IdentNode identNode = this.getIdentNode();
        RetypedEdge retypedEdge = new RetypedEdge(identNode.getIdent(), edgeType, identNode.getAnnotations(), this.isMaybeDeleted(), this.isMaybeRetyped(), false, this.context);
        Edge edge = this.old.getEdge();
        retypedEdge.setOldEdge(edge);
        if (this.inheritsType()) {
            assert (this.copyKind == ConstraintDeclNode.CopyKind.None);
            retypedEdge.setTypeofCopy(this.typeEdgeDecl.checkIR(Edge.class), this.copyKind);
        }
        return retypedEdge;
    }

    static {
        EdgeTypeChangeDeclNode.setName(EdgeTypeChangeDeclNode.class, "edge type change decl");
        edgeResolver = new DeclarationResolver<EdgeDeclNode>(EdgeDeclNode.class);
    }
}

