/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.pattern.Edge;
import java.util.Collection;
import java.util.Vector;

public class EdgeInterfaceTypeChangeDeclNode
extends EdgeDeclNode {
    private IdentNode interfaceTypeUnresolved;
    public TypeDeclNode interfaceType = null;
    private static final DeclarationResolver<TypeDeclNode> typeResolver;

    public EdgeInterfaceTypeChangeDeclNode(IdentNode identNode, BaseNode baseNode, int n, IdentNode identNode2, PatternGraphLhsNode patternGraphLhsNode, boolean bl) {
        super(identNode, baseNode, ConstraintDeclNode.CopyKind.None, n, TypeExprNode.getEmpty(), patternGraphLhsNode, bl, false);
        this.interfaceTypeUnresolved = identNode2;
        this.becomeParent(this.interfaceTypeUnresolved);
    }

    @Override
    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeEdgeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.getValidVersion(this.interfaceTypeUnresolved, this.interfaceType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("interfaceType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        this.interfaceType = (TypeDeclNode)typeResolver.resolve(this.interfaceTypeUnresolved, this);
        if (this.interfaceType == null) {
            return false;
        }
        if (!this.interfaceType.resolve()) {
            return false;
        }
        if (!(this.interfaceType.getDeclType() instanceof EdgeTypeNode)) {
            this.interfaceTypeUnresolved.reportError("The interface type of edge parameter " + this.getIdentNode() + " must be an edge type (given is " + this.interfaceType.getDeclType().getKind() + " " + this.interfaceType.getDeclType().getTypeName() + ").");
            return false;
        }
        if (!bl) {
            return false;
        }
        EdgeTypeNode edgeTypeNode = (EdgeTypeNode)this.interfaceType.getDeclType();
        EdgeTypeNode edgeTypeNode2 = (EdgeTypeNode)this.typeTypeDecl.getDeclType();
        if (!edgeTypeNode2.isA(edgeTypeNode)) {
            this.interfaceTypeUnresolved.reportWarning("The interface type " + edgeTypeNode.toStringWithDeclarationCoords() + " of edge parameter " + this.ident.toString() + " is not a supertype of " + edgeTypeNode2.toStringWithDeclarationCoords() + ".");
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        TypeChecker typeChecker = new TypeChecker(EdgeTypeNode.class);
        boolean bl = super.checkLocal() & typeChecker.check(this.interfaceType, error);
        if (!bl) {
            return false;
        }
        return bl & this.onlyPatternEdgesCanChangeInterfaceType();
    }

    private boolean onlyPatternEdgesCanChangeInterfaceType() {
        if ((this.context & 1) == 0) {
            return true;
        }
        this.reportError("Rewrite part edge parameters cannot change the interface type, only pattern edges can (this is violated by " + this.getIdentNode() + ").");
        return false;
    }

    @Override
    protected IR constructIR() {
        Edge edge = (Edge)super.constructIR();
        EdgeTypeNode edgeTypeNode = (EdgeTypeNode)this.interfaceType.getDeclType();
        EdgeType edgeType = edgeTypeNode.getEdgeType();
        edge.setParameterInterfaceType(edgeType);
        return edge;
    }

    static {
        EdgeInterfaceTypeChangeDeclNode.setName(EdgeInterfaceTypeChangeDeclNode.class, "edge interface type change decl");
        typeResolver = new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class);
    }
}

