/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.pattern.NameOrAttributeInitializationNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.Checker;
import de.unika.ipd.grgen.ast.util.DeclarationPairResolver;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.NameOrAttributeInitialization;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class EdgeDeclNode
extends ConstraintDeclNode {
    protected EdgeDeclNode typeEdgeDecl = null;
    protected TypeDeclNode typeTypeDecl = null;
    protected static final DeclarationPairResolver<EdgeDeclNode, TypeDeclNode> typeResolver;
    private static final Checker typeChecker;

    public EdgeDeclNode(IdentNode identNode, BaseNode baseNode, ConstraintDeclNode.CopyKind copyKind, int n, TypeExprNode typeExprNode, PatternGraphLhsNode patternGraphLhsNode, boolean bl, boolean bl2) {
        super(identNode, baseNode, copyKind, n, typeExprNode, patternGraphLhsNode, bl, bl2);
        this.setName("edge");
    }

    public EdgeDeclNode(IdentNode identNode, BaseNode baseNode, ConstraintDeclNode.CopyKind copyKind, int n, TypeExprNode typeExprNode, PatternGraphLhsNode patternGraphLhsNode) {
        this(identNode, baseNode, copyKind, n, typeExprNode, patternGraphLhsNode, false, false);
    }

    public EdgeDeclNode cloneForAuto(PatternGraphLhsNode patternGraphLhsNode) {
        EdgeDeclNode edgeDeclNode = new EdgeDeclNode(this.ident, this.typeUnresolved, this.copyKind, this.context, this.constraints, patternGraphLhsNode, this.maybeNull, this.defEntityToBeYieldedTo);
        edgeDeclNode.resolve();
        if (this.typeEdgeDecl != null) {
            this.reportError("A typeof edge cannot be used in an auto statement (as is the case for " + this.getIdentNode() + ").");
        }
        return edgeDeclNode;
    }

    public EdgeDeclNode(IdentNode identNode, TypeDeclNode typeDeclNode, int n, BaseNode baseNode, PatternGraphLhsNode patternGraphLhsNode) {
        this(identNode, typeDeclNode, ConstraintDeclNode.CopyKind.None, n, TypeExprNode.getEmpty(), patternGraphLhsNode);
        baseNode.becomeParent(this);
        this.resolve();
        this.check();
    }

    @Override
    public EdgeTypeNode getDeclType() {
        assert (this.isResolved());
        DeclNode declNode = this.getValidResolvedVersion(this.typeEdgeDecl, this.typeTypeDecl);
        TypeNode typeNode = declNode.getDeclType();
        return (EdgeTypeNode)typeNode;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.typeEdgeDecl, this.typeTypeDecl));
        vector.add(this.constraints);
        vector.add(this.nameOrAttributeInits);
        if (this.initialization != null) {
            vector.add(this.initialization);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("constraints");
        vector.add("nameOrAttributeInits");
        if (this.initialization != null) {
            vector.add("initialization expression");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        TypeDeclNode typeDeclNode;
        Object object = typeResolver.resolve(this.typeUnresolved, this);
        if (object == null) {
            return false;
        }
        this.typeEdgeDecl = (EdgeDeclNode)((Pair)object).fst;
        this.typeTypeDecl = (TypeDeclNode)((Pair)object).snd;
        if (this.typeEdgeDecl != null) {
            HashSet<EdgeDeclNode> hashSet = new HashSet<EdgeDeclNode>();
            EdgeDeclNode edgeDeclNode = this.typeEdgeDecl;
            EdgeDeclNode edgeDeclNode2 = this.typeEdgeDecl.typeEdgeDecl;
            while (edgeDeclNode2 != null) {
                if (hashSet.contains(edgeDeclNode2)) {
                    this.reportError("Circular typeof/copy not allowed (as is the case for " + this.getKind() + " " + this.getIdentNode() + ").");
                    return false;
                }
                hashSet.add(edgeDeclNode2);
                edgeDeclNode = edgeDeclNode2;
                edgeDeclNode2 = edgeDeclNode2.typeEdgeDecl;
            }
            typeDeclNode = edgeDeclNode.typeTypeDecl;
        } else {
            typeDeclNode = this.typeTypeDecl;
        }
        if (!typeDeclNode.resolve()) {
            return false;
        }
        if (!(typeDeclNode.getDeclType() instanceof EdgeTypeNode)) {
            this.typeUnresolved.reportError("Type of edge" + this.emptyWhenAnonymousPostfix(" ") + " must be an edge type (given is " + typeDeclNode.getDeclType().getKind() + " " + typeDeclNode.getDeclType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    private void warnOnTypeofOfRhsEdges() {
        if ((this.context & 1) == 0) {
            return;
        }
        boolean bl = true;
        while (this.inheritsType() && (this.typeEdgeDecl.context & 1) == 1) {
            if (bl) {
                bl = false;
                this.reportWarning("Type of edge " + this.typeEdgeDecl.ident + " is statically known (to be " + this.typeEdgeDecl.getDeclType().getTypeName() + ", the typeof is thus pointless).");
            }
            this.typeTypeDecl = this.typeEdgeDecl.typeTypeDecl;
            this.typeEdgeDecl = this.typeEdgeDecl.typeEdgeDecl;
        }
    }

    @Override
    protected boolean checkLocal() {
        this.warnOnTypeofOfRhsEdges();
        return super.checkLocal() & typeChecker.check(this.getValidResolvedVersion(this.typeEdgeDecl, this.typeTypeDecl), error);
    }

    @Override
    protected String extraNodeInfo() {
        return "";
    }

    @Override
    public Color getNodeColor() {
        return Color.YELLOW;
    }

    public Edge getEdge() {
        return this.checkIR(Edge.class);
    }

    public final boolean inheritsType() {
        assert (this.isResolved());
        return this.typeEdgeDecl != null;
    }

    @Override
    protected IR constructIR() {
        EdgeTypeNode edgeTypeNode = this.getDeclType();
        EdgeType edgeType = edgeTypeNode.checkIR(EdgeType.class);
        IdentNode identNode = this.getIdentNode();
        Edge edge = new Edge(identNode.getIdent(), edgeType, identNode.getAnnotations(), this.directlyNestingLHSGraph != null ? this.directlyNestingLHSGraph.getPatternGraph() : null, this.isMaybeDeleted(), this.isMaybeRetyped(), this.defEntityToBeYieldedTo, this.context);
        edge.setConstraints(this.getConstraints());
        if (edge.getConstraints().contains(edge.getType())) {
            this.reportError("The own edge type may not be contained in the type constraint list (but " + edge.getType() + " is contained for " + this.getIdentNode() + ").");
        }
        if (this.inheritsType()) {
            edge.setTypeofCopy(this.typeEdgeDecl.checkIR(Edge.class), this.copyKind);
        }
        edge.setMaybeNull(this.maybeNull);
        if (this.initialization != null) {
            this.initialization = this.initialization.evaluate();
            edge.setInitialization(this.initialization.checkIR(Expression.class));
        }
        for (NameOrAttributeInitializationNode nameOrAttributeInitializationNode : this.nameOrAttributeInits.getChildren()) {
            nameOrAttributeInitializationNode.ownerIR = edge;
            edge.addNameOrAttributeInitialization(nameOrAttributeInitializationNode.checkIR(NameOrAttributeInitialization.class));
        }
        return edge;
    }

    public static String getKindStr() {
        return "edge";
    }

    static {
        EdgeDeclNode.setName(EdgeDeclNode.class, "edge declaration");
        typeResolver = new DeclarationPairResolver<EdgeDeclNode, TypeDeclNode>(EdgeDeclNode.class, TypeDeclNode.class);
        typeChecker = new TypeChecker(EdgeTypeNode.class);
    }
}

