/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.pattern;

import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.AlternativeCaseDeclNode;
import de.unika.ipd.grgen.ast.type.AlternativeTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.pattern.Alternative;
import java.util.Collection;
import java.util.Vector;

public class AlternativeDeclNode
extends DeclNode {
    private static AlternativeTypeNode alternativeType;
    private Vector<AlternativeCaseDeclNode> children = new Vector();

    public AlternativeDeclNode(IdentNode identNode) {
        super(identNode, alternativeType);
    }

    public void addChild(AlternativeCaseDeclNode alternativeCaseDeclNode) {
        assert (!this.isResolved());
        this.becomeParent(alternativeCaseDeclNode);
        this.children.add(alternativeCaseDeclNode);
    }

    public Collection<AlternativeCaseDeclNode> getChildren() {
        return this.children;
    }

    @Override
    protected Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if (this.children.isEmpty()) {
            this.reportError("The alternative pattern is empty.");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        Alternative alternative = new Alternative(this.ident.getIdent());
        for (AlternativeCaseDeclNode alternativeCaseDeclNode : this.children) {
            Rule rule = alternativeCaseDeclNode.checkIR(Rule.class);
            alternative.addAlternativeCase(rule);
        }
        return alternative;
    }

    @Override
    public AlternativeTypeNode getDeclType() {
        assert (this.isResolved());
        return alternativeType;
    }

    static {
        AlternativeDeclNode.setName(AlternativeDeclNode.class, "alternative");
        alternativeType = new AlternativeTypeNode();
    }
}

