/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclBaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.SingleNodeConnNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.ErrorTypeNode;
import de.unika.ipd.grgen.ast.type.executable.ProcedureTypeNode;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Procedure;
import de.unika.ipd.grgen.ir.executable.ProcedureMethod;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class ProcedureDeclNode
extends ProcedureDeclBaseNode {
    protected CollectNode<BaseNode> parametersUnresolved;
    protected CollectNode<DeclNode> parameters;
    public CollectNode<EvalStatementNode> evalStatements;
    boolean isMethod;
    static final ProcedureTypeNode procedureType;

    public ProcedureDeclNode(IdentNode identNode, CollectNode<EvalStatementNode> collectNode, CollectNode<BaseNode> collectNode2, CollectNode<BaseNode> collectNode3, boolean bl) {
        super(identNode, procedureType);
        this.evalStatements = collectNode;
        this.becomeParent(this.evalStatements);
        this.parametersUnresolved = collectNode2;
        this.becomeParent(this.parametersUnresolved);
        this.resultsUnresolved = collectNode3;
        this.becomeParent(this.resultsUnresolved);
        this.isMethod = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.evalStatements);
        vector.add(this.parametersUnresolved);
        vector.add(this.getValidVersion(this.resultsUnresolved, this.resultTypesCollectNode));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("evals");
        vector.add("params");
        vector.add("ret");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        this.parameters = new CollectNode();
        for (BaseNode object : this.parametersUnresolved.getChildren()) {
            BaseNode baseNode;
            if (object instanceof ConnectionNode) {
                baseNode = (ConnectionNode)object;
                this.parameters.addChild(baseNode.getEdge().getDecl());
                continue;
            }
            if (object instanceof SingleNodeConnNode) {
                baseNode = ((SingleNodeConnNode)object).getNode();
                this.parameters.addChild((DeclNode)baseNode);
                continue;
            }
            if (object instanceof VarDeclNode) {
                this.parameters.addChild((VarDeclNode)object);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported parameter (" + object + ")");
        }
        this.parameterTypes = new Vector();
        for (DeclNode declNode : this.parameters.getChildren()) {
            this.parameterTypes.add(declNode.getDeclType());
        }
        boolean bl = true;
        for (BaseNode baseNode : this.parameterTypes) {
            if (baseNode != null && !(baseNode instanceof ErrorTypeNode)) continue;
            bl = false;
        }
        return bl;
    }

    public Procedure getProcedure() {
        return this.checkIR(Procedure.class);
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return procedureType;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Procedure procedure = this.isMethod ? new ProcedureMethod(this.getIdentNode().toString(), this.getIdentNode().getIdent()) : new Procedure(this.getIdentNode().toString(), this.getIdentNode().getIdent());
        this.setIR(procedure);
        for (TypeNode baseNode : this.resultTypesCollectNode.getChildren()) {
            procedure.addReturnType(baseNode.checkIR(Type.class));
        }
        for (DeclNode declNode : this.parameters.getChildren()) {
            procedure.addParameter(declNode.checkIR(Entity.class));
        }
        for (EvalStatementNode evalStatementNode : this.evalStatements.getChildren()) {
            procedure.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return procedure;
    }

    public static String getKindStr() {
        return "procedure";
    }

    static {
        ProcedureDeclNode.setName(ProcedureDeclNode.class, "procedure declaration");
        procedureType = new ProcedureTypeNode();
    }
}

