/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionOrOperatorDeclBaseNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorEvaluator;
import de.unika.ipd.grgen.ast.expr.ArithmeticOperatorNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.executable.OperatorTypeNode;
import de.unika.ipd.grgen.parser.Symbol;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Vector;

public class OperatorDeclNode
extends FunctionOrOperatorDeclBaseNode {
    private static final OperatorTypeNode operatorType = new OperatorTypeNode();
    private static final Map<Operator, Integer> arities = new HashMap<Operator, Integer>();
    private static final Map<Operator, String> names = new HashMap<Operator, String>();
    static final TypeNode STRING;
    static final TypeNode BOOLEAN;
    static final TypeNode BYTE;
    static final TypeNode SHORT;
    static final TypeNode INT;
    static final TypeNode LONG;
    static final TypeNode FLOAT;
    static final TypeNode DOUBLE;
    static final TypeNode OBJECT;
    static final TypeNode GRAPH;
    static final TypeNode NULL;
    static final TypeNode ENUM;
    static final TypeNode TYPE;
    static final TypeNode UNTYPED;
    private static final Map<Operator, HashSet<OperatorDeclNode>> operators;
    private static final OperatorDeclNode INVALID;
    Operator operator;
    private OperatorEvaluator evaluator;

    public static final void makeOp(Operator operator, TypeNode typeNode, TypeNode[] typeNodeArray, OperatorEvaluator operatorEvaluator) {
        HashSet<OperatorDeclNode> hashSet = operators.get((Object)operator);
        if (hashSet == null) {
            hashSet = new LinkedHashSet<OperatorDeclNode>();
            operators.put(operator, hashSet);
        }
        OperatorDeclNode operatorDeclNode = new OperatorDeclNode(operator, typeNode, typeNodeArray, operatorEvaluator);
        hashSet.add(operatorDeclNode);
    }

    public static final void makeBinOp(Operator operator, TypeNode typeNode, TypeNode typeNode2, TypeNode typeNode3, OperatorEvaluator operatorEvaluator) {
        OperatorDeclNode.makeOp(operator, typeNode, new TypeNode[]{typeNode2, typeNode3}, operatorEvaluator);
    }

    public static final void makeUnOp(Operator operator, TypeNode typeNode, TypeNode typeNode2, OperatorEvaluator operatorEvaluator) {
        OperatorDeclNode.makeOp(operator, typeNode, new TypeNode[]{typeNode2}, operatorEvaluator);
    }

    public TypeNode[] getOperandTypes() {
        TypeNode[] typeNodeArray = new TypeNode[this.parameterTypes.size()];
        return this.parameterTypes.toArray(typeNodeArray);
    }

    public static int getArity(Operator operator) {
        return arities.get((Object)operator);
    }

    public static String getName(Operator operator) {
        return names.get((Object)operator);
    }

    public static OperatorDeclNode getNearestOperator(Operator operator, Vector<TypeNode> vector) {
        OperatorDeclNode operatorDeclNode = INVALID;
        int n = Integer.MAX_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean[] blArray = new boolean[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == BasicTypeNode.voidType) {
                bl = true;
                continue;
            }
            if (vector.get(i) == BasicTypeNode.untypedType) {
                bl2 = true;
                continue;
            }
            if (!(vector.get(i) instanceof EnumTypeNode)) continue;
            bl3 = true;
            blArray[i] = true;
        }
        HashSet<OperatorDeclNode> hashSet = operators.get((Object)operator);
        if (hashSet == null) {
            return INVALID;
        }
        for (OperatorDeclNode operatorDeclNode2 : hashSet) {
            operatorDeclNode2.resolve();
            int n2 = operatorDeclNode2.getDistance(vector);
            String string = "";
            for (TypeNode typeNode : vector) {
                string = string + typeNode.toString() + ", ";
            }
            debug.report(4, "dist: " + n2 + " for signature: " + operatorDeclNode2 + " against " + string);
            if (n2 == Integer.MAX_VALUE) continue;
            if (bl3) {
                n2 *= 2;
                TypeNode[] typeNodeArray = operatorDeclNode2.getOperandTypes();
                for (int i = 0; i < vector.size(); ++i) {
                    if (!blArray[i] || typeNodeArray[i] != BasicTypeNode.intType) continue;
                    --n2;
                }
            }
            if (n2 >= n) continue;
            n = n2;
            operatorDeclNode = operatorDeclNode2;
            if (n != 0) continue;
            break;
        }
        if (!bl && (bl3 && n >= 4 || !bl3 && n >= 2)) {
            operatorDeclNode = INVALID;
            operatorDeclNode.resolve();
        }
        boolean bl4 = false;
        for (TypeNode typeNode : operatorDeclNode.getOperandTypes()) {
            if (typeNode != UNTYPED) continue;
            bl4 = true;
        }
        if (bl4 && !bl2) {
            operatorDeclNode = INVALID;
            operatorDeclNode.resolve();
        }
        debug.report(4, "selected: " + operatorDeclNode);
        return operatorDeclNode;
    }

    private OperatorDeclNode(Operator operator, TypeNode typeNode, TypeNode[] typeNodeArray, OperatorEvaluator operatorEvaluator) {
        super(new IdentNode(Symbol.Definition.getInvalid()), operatorType);
        this.resultType = typeNode;
        this.parameterTypes = new Vector();
        for (TypeNode typeNode2 : typeNodeArray) {
            this.parameterTypes.add(typeNode2);
        }
        this.operator = operator;
        this.evaluator = operatorEvaluator;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = this.resultType.resolve();
        for (TypeNode typeNode : this.parameterTypes) {
            bl &= typeNode.resolve();
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return operatorType;
    }

    public ExprNode evaluate(ArithmeticOperatorNode arithmeticOperatorNode, ExprNode[] exprNodeArray) {
        return this.evaluator.evaluate(arithmeticOperatorNode, this, exprNodeArray);
    }

    public boolean isValid() {
        return true;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public String toString() {
        String string = this.getResultType().toString() + " ";
        string = string + names.get((Object)this.operator) + "(";
        TypeNode[] typeNodeArray = this.getOperandTypes();
        for (int i = 0; i < typeNodeArray.length; ++i) {
            string = string + (i == 0 ? "" : ",") + typeNodeArray[i];
        }
        string = string + ")";
        return string;
    }

    static {
        Integer n = new Integer(2);
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(0);
        for (Operator operator : Operator.values()) {
            arities.put(operator, n);
        }
        arities.put(Operator.COND, new Integer(3));
        arities.put(Operator.LOG_NOT, n2);
        arities.put(Operator.BIT_NOT, n2);
        arities.put(Operator.NEG, n2);
        arities.put(Operator.CONST, n3);
        arities.put(Operator.ERROR, n3);
        names.put(Operator.COND, "Cond");
        names.put(Operator.LOG_OR, "LogOr");
        names.put(Operator.LOG_AND, "LogAnd");
        names.put(Operator.BIT_XOR, "BitXor");
        names.put(Operator.BIT_OR, "BitOr");
        names.put(Operator.BIT_AND, "BitAnd");
        names.put(Operator.EQ, "Eq");
        names.put(Operator.NE, "Ne");
        names.put(Operator.LT, "Lt");
        names.put(Operator.LE, "Le");
        names.put(Operator.GT, "Gt");
        names.put(Operator.GE, "Ge");
        names.put(Operator.SHL, "Shl");
        names.put(Operator.SHR, "Shr");
        names.put(Operator.BIT_SHR, "BitShr");
        names.put(Operator.ADD, "Add");
        names.put(Operator.SUB, "Sub");
        names.put(Operator.MUL, "Mul");
        names.put(Operator.DIV, "Div");
        names.put(Operator.MOD, "Mod");
        names.put(Operator.LOG_NOT, "LogNot");
        names.put(Operator.BIT_NOT, "BitNot");
        names.put(Operator.NEG, "Neg");
        names.put(Operator.CONST, "Const");
        names.put(Operator.IN, "In");
        names.put(Operator.INDEX, "IndexedAccess");
        names.put(Operator.EXCEPT, "Except");
        names.put(Operator.SE, "Se");
        names.put(Operator.ERROR, "Error");
        STRING = BasicTypeNode.stringType;
        BOOLEAN = BasicTypeNode.booleanType;
        BYTE = BasicTypeNode.byteType;
        SHORT = BasicTypeNode.shortType;
        INT = BasicTypeNode.intType;
        LONG = BasicTypeNode.longType;
        FLOAT = BasicTypeNode.floatType;
        DOUBLE = BasicTypeNode.doubleType;
        OBJECT = BasicTypeNode.objectType;
        GRAPH = BasicTypeNode.graphType;
        NULL = BasicTypeNode.nullType;
        ENUM = BasicTypeNode.enumItemType;
        TYPE = BasicTypeNode.typeType;
        UNTYPED = BasicTypeNode.untypedType;
        operators = new HashMap<Operator, HashSet<OperatorDeclNode>>();
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, STRING, STRING, OperatorEvaluator.stringEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, STRING, STRING, OperatorEvaluator.stringEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GE, BOOLEAN, STRING, STRING, OperatorEvaluator.stringEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GT, BOOLEAN, STRING, STRING, OperatorEvaluator.stringEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LE, BOOLEAN, STRING, STRING, OperatorEvaluator.stringEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LT, BOOLEAN, STRING, STRING, OperatorEvaluator.stringEvaluator);
        OperatorDeclNode.makeBinOp(Operator.IN, BOOLEAN, STRING, STRING, OperatorEvaluator.stringEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, OBJECT, OBJECT, OperatorEvaluator.objectEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, OBJECT, OBJECT, OperatorEvaluator.objectEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, NULL, NULL, OperatorEvaluator.nullEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, NULL, NULL, OperatorEvaluator.nullEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, GRAPH, GRAPH, OperatorEvaluator.subgraphEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, GRAPH, GRAPH, OperatorEvaluator.subgraphEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SE, BOOLEAN, GRAPH, GRAPH, OperatorEvaluator.subgraphEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GE, BOOLEAN, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GT, BOOLEAN, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LE, BOOLEAN, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LT, BOOLEAN, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GE, BOOLEAN, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GT, BOOLEAN, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LE, BOOLEAN, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LT, BOOLEAN, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GE, BOOLEAN, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GT, BOOLEAN, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LE, BOOLEAN, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LT, BOOLEAN, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GE, BOOLEAN, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GT, BOOLEAN, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LE, BOOLEAN, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LT, BOOLEAN, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LOG_AND, BOOLEAN, BOOLEAN, BOOLEAN, OperatorEvaluator.booleanEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LOG_OR, BOOLEAN, BOOLEAN, BOOLEAN, OperatorEvaluator.booleanEvaluator);
        OperatorDeclNode.makeUnOp(Operator.LOG_NOT, BOOLEAN, BOOLEAN, OperatorEvaluator.booleanEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_AND, BOOLEAN, BOOLEAN, BOOLEAN, OperatorEvaluator.booleanEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_OR, BOOLEAN, BOOLEAN, BOOLEAN, OperatorEvaluator.booleanEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_XOR, BOOLEAN, BOOLEAN, BOOLEAN, OperatorEvaluator.booleanEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, BOOLEAN, BOOLEAN, OperatorEvaluator.booleanEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, BOOLEAN, BOOLEAN, OperatorEvaluator.booleanEvaluator);
        OperatorDeclNode.makeBinOp(Operator.ADD, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SUB, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MUL, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.DIV, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MOD, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SHL, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SHR, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_SHR, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_OR, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_AND, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_XOR, INT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeUnOp(Operator.NEG, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeUnOp(Operator.BIT_NOT, INT, INT, OperatorEvaluator.intEvaluator);
        OperatorDeclNode.makeBinOp(Operator.ADD, LONG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SUB, LONG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MUL, LONG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.DIV, LONG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MOD, LONG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SHL, LONG, LONG, INT, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SHR, LONG, LONG, INT, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_SHR, LONG, LONG, INT, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_OR, LONG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_AND, LONG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_XOR, LONG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeUnOp(Operator.NEG, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeUnOp(Operator.BIT_NOT, LONG, LONG, OperatorEvaluator.longEvaluator);
        OperatorDeclNode.makeBinOp(Operator.ADD, FLOAT, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SUB, FLOAT, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MUL, FLOAT, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.DIV, FLOAT, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MOD, FLOAT, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeUnOp(Operator.NEG, FLOAT, FLOAT, OperatorEvaluator.floatEvaluator);
        OperatorDeclNode.makeBinOp(Operator.ADD, DOUBLE, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SUB, DOUBLE, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MUL, DOUBLE, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.DIV, DOUBLE, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MOD, DOUBLE, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeUnOp(Operator.NEG, DOUBLE, DOUBLE, OperatorEvaluator.doubleEvaluator);
        OperatorDeclNode.makeBinOp(Operator.ADD, STRING, STRING, STRING, OperatorEvaluator.stringEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, TYPE, TYPE, OperatorEvaluator.typeEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, TYPE, TYPE, OperatorEvaluator.typeEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GE, BOOLEAN, TYPE, TYPE, OperatorEvaluator.typeEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GT, BOOLEAN, TYPE, TYPE, OperatorEvaluator.typeEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LE, BOOLEAN, TYPE, TYPE, OperatorEvaluator.typeEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LT, BOOLEAN, TYPE, TYPE, OperatorEvaluator.typeEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, BYTE, new TypeNode[]{BOOLEAN, BYTE, BYTE}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, SHORT, new TypeNode[]{BOOLEAN, SHORT, SHORT}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, INT, new TypeNode[]{BOOLEAN, INT, INT}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, LONG, new TypeNode[]{BOOLEAN, LONG, LONG}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, FLOAT, new TypeNode[]{BOOLEAN, FLOAT, FLOAT}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, DOUBLE, new TypeNode[]{BOOLEAN, DOUBLE, DOUBLE}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, STRING, new TypeNode[]{BOOLEAN, STRING, STRING}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, BOOLEAN, new TypeNode[]{BOOLEAN, BOOLEAN, BOOLEAN}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, TYPE, new TypeNode[]{BOOLEAN, TYPE, TYPE}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, OBJECT, new TypeNode[]{BOOLEAN, OBJECT, OBJECT}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EQ, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.NE, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GE, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.GT, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LE, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LT, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.IN, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SE, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LOG_AND, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.LOG_OR, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeUnOp(Operator.LOG_NOT, BOOLEAN, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_AND, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_OR, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.BIT_XOR, BOOLEAN, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.EXCEPT, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.ADD, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.SUB, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MUL, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.DIV, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.MOD, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeUnOp(Operator.NEG, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, BYTE, new TypeNode[]{UNTYPED, BYTE, BYTE}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, SHORT, new TypeNode[]{UNTYPED, SHORT, SHORT}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, INT, new TypeNode[]{UNTYPED, INT, INT}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, LONG, new TypeNode[]{UNTYPED, LONG, LONG}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, FLOAT, new TypeNode[]{UNTYPED, FLOAT, FLOAT}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, DOUBLE, new TypeNode[]{UNTYPED, DOUBLE, DOUBLE}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, STRING, new TypeNode[]{UNTYPED, STRING, STRING}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, BOOLEAN, new TypeNode[]{UNTYPED, BOOLEAN, BOOLEAN}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, TYPE, new TypeNode[]{UNTYPED, TYPE, TYPE}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, OBJECT, new TypeNode[]{UNTYPED, OBJECT, OBJECT}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, UNTYPED, new TypeNode[]{BOOLEAN, UNTYPED, UNTYPED}, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeOp(Operator.COND, UNTYPED, new TypeNode[]{UNTYPED, UNTYPED, UNTYPED}, OperatorEvaluator.untypedEvaluator);
        OperatorDeclNode.makeBinOp(Operator.INDEX, UNTYPED, UNTYPED, UNTYPED, OperatorEvaluator.untypedEvaluator);
        INVALID = new OperatorDeclNode(Operator.ERROR, BasicTypeNode.errorType, new TypeNode[0], OperatorEvaluator.emptyEvaluator){

            @Override
            public boolean isValid() {
                return false;
            }
        };
    }

    public static enum Operator {
        ERROR,
        LOG_OR,
        LOG_AND,
        BIT_OR,
        BIT_XOR,
        BIT_AND,
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE,
        SHL,
        SHR,
        BIT_SHR,
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        LOG_NOT,
        BIT_NOT,
        NEG,
        CONST,
        COND,
        IN,
        INDEX,
        EXCEPT,
        SE;

    }
}

