/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.MatchClassFilterCharacter;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoDeclNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.MatchClassFilterAutoGenerated;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class MatchClassFilterAutoGeneratedDeclNode
extends FilterAutoDeclNode
implements MatchClassFilterCharacter {
    public String name;
    public ArrayList<String> entities;
    protected ArrayList<TypeNode> entityTypes;
    protected IdentNode matchTypeUnresolved;
    protected DefinedMatchTypeNode matchType;
    private static final DeclarationTypeResolver<DefinedMatchTypeNode> matchTypeResolver;

    public MatchClassFilterAutoGeneratedDeclNode(IdentNode identNode, String string, ArrayList<String> arrayList, IdentNode identNode2) {
        super(identNode);
        this.name = string;
        this.entities = arrayList;
        this.matchTypeUnresolved = identNode2;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.matchTypeUnresolved);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("matchType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (!(this.matchTypeUnresolved instanceof PackageIdentNode)) {
            MatchClassFilterAutoGeneratedDeclNode.fixupDefinition(this.matchTypeUnresolved, this.matchTypeUnresolved.getScope());
        }
        this.matchType = (DefinedMatchTypeNode)matchTypeResolver.resolve(this.matchTypeUnresolved, this);
        return this.matchType != null;
    }

    @Override
    protected boolean checkLocal() {
        if (this.entities == null) {
            if (!this.name.equals("auto")) {
                this.reportError("Unknown auto-generated filter " + this.name + " (only auto comes without parameters).");
                return false;
            }
            return true;
        }
        this.entityTypes = new ArrayList();
        for (int i = 0; i < this.entities.size(); ++i) {
            if (this.name.equals("keepOneForEachAccumulateBy") && i == this.entities.size() - 1) continue;
            String string = this.entities.get(i);
            DeclNode declNode = this.matchType.tryGetMember(string);
            if (declNode == null) {
                this.reportError("The entity " + string + " referenced in the filter declaration " + this.getFilterNameWithEntitySuffix() + " is not known in the match class " + this.matchType.getIdentNode() + ".");
                return false;
            }
            this.entityTypes.add(declNode.getDeclType());
        }
        return true;
    }

    @Override
    public String getFilterName() {
        return this.name;
    }

    public String getFilterNameWithEntitySuffix() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        if (this.entities != null && !this.entities.isEmpty()) {
            stringBuilder.append("<");
            boolean bl = true;
            for (String string : this.entities) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    @Override
    public DefinedMatchTypeNode getMatchTypeNode() {
        return this.matchType;
    }

    public MatchClassFilterAutoGenerated getMatchClassFilterAutoGenerated() {
        return this.checkIR(MatchClassFilterAutoGenerated.class);
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        MatchClassFilterAutoGenerated matchClassFilterAutoGenerated = new MatchClassFilterAutoGenerated(this.name, this.entities);
        this.setIR(matchClassFilterAutoGenerated);
        DefinedMatchType definedMatchType = this.matchType.checkIR(DefinedMatchType.class);
        matchClassFilterAutoGenerated.setMatchClass(definedMatchType);
        definedMatchType.addMatchClassFilter(matchClassFilterAutoGenerated);
        if (this.entityTypes != null) {
            for (TypeNode typeNode : this.entityTypes) {
                matchClassFilterAutoGenerated.addEntityType(typeNode.getType());
            }
        }
        return matchClassFilterAutoGenerated;
    }

    static {
        MatchClassFilterAutoGeneratedDeclNode.setName(MatchClassFilterAutoGeneratedDeclNode.class, "match filter function declaration");
        matchTypeResolver = new DeclarationTypeResolver<DefinedMatchTypeNode>(DefinedMatchTypeNode.class);
    }
}

