/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.FunctionSignature;
import java.util.Vector;

public abstract class FunctionOrOperatorDeclBaseNode
extends DeclNode
implements FunctionSignature {
    public TypeNode resultType;
    protected Vector<TypeNode> parameterTypes;

    public FunctionOrOperatorDeclBaseNode(IdentNode identNode, BaseNode baseNode) {
        super(identNode, baseNode);
    }

    @Override
    public TypeNode getResultType() {
        assert (this.isResolved());
        return this.resultType;
    }

    @Override
    public Vector<TypeNode> getParameterTypes() {
        assert (this.isResolved());
        return this.parameterTypes;
    }

    @Override
    public int getDistance(Vector<TypeNode> vector) {
        if (vector.size() != this.parameterTypes.size()) {
            return Integer.MAX_VALUE;
        }
        int n = 0;
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            debug.report(4, "" + i + ": arg type: " + vector.get(i) + ", operand type: " + this.parameterTypes.get(i));
            boolean bl = vector.get(i).isEqual(this.parameterTypes.get(i));
            boolean bl2 = vector.get(i).isCompatibleTo(this.parameterTypes.get(i));
            debug.report(4, "equal: " + bl + ", compatible: " + bl2);
            int n2 = vector.get(i).compatibilityDistance(this.parameterTypes.get(i));
            if (n2 == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            n += n2;
        }
        return n;
    }
}

