/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.FunctionAutoNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclBaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.SingleNodeConnNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.ErrorTypeNode;
import de.unika.ipd.grgen.ast.type.executable.FunctionTypeNode;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Function;
import de.unika.ipd.grgen.ir.executable.FunctionMethod;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class FunctionDeclNode
extends FunctionDeclBaseNode {
    protected CollectNode<BaseNode> parametersUnresolved;
    protected CollectNode<DeclNode> parameters;
    public CollectNode<EvalStatementNode> evalStatements;
    public FunctionAutoNode functionAuto;
    boolean isMethod;
    protected static final FunctionTypeNode functionType;

    public FunctionDeclNode(IdentNode identNode, CollectNode<EvalStatementNode> collectNode, FunctionAutoNode functionAutoNode, CollectNode<BaseNode> collectNode2, BaseNode baseNode, boolean bl) {
        super(identNode, functionType);
        this.evalStatements = collectNode;
        this.becomeParent(this.evalStatements);
        this.functionAuto = functionAutoNode;
        this.parametersUnresolved = collectNode2;
        this.becomeParent(this.parametersUnresolved);
        this.resultUnresolved = baseNode;
        this.becomeParent(this.resultUnresolved);
        this.isMethod = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.evalStatements);
        vector.add(this.parametersUnresolved);
        vector.add(this.getValidVersion(this.resultUnresolved, this.resultType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("evals");
        vector.add("params");
        vector.add("ret");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = super.resolveLocal();
        if (this.functionAuto != null) {
            bl &= this.functionAuto.resolveLocal();
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        this.parameters = new CollectNode();
        for (BaseNode object : this.parametersUnresolved.getChildren()) {
            BaseNode baseNode;
            if (object instanceof ConnectionNode) {
                baseNode = (ConnectionNode)object;
                this.parameters.addChild(baseNode.getEdge().getDecl());
                continue;
            }
            if (object instanceof SingleNodeConnNode) {
                baseNode = ((SingleNodeConnNode)object).getNode();
                this.parameters.addChild((DeclNode)baseNode);
                continue;
            }
            if (object instanceof VarDeclNode) {
                this.parameters.addChild((VarDeclNode)object);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported parameter (" + object + ")");
        }
        this.parameterTypes = new Vector();
        for (DeclNode declNode : this.parameters.getChildren()) {
            this.parameterTypes.add(declNode.getDeclType());
        }
        boolean bl = true;
        for (BaseNode baseNode : this.parameterTypes) {
            if (baseNode != null && !(baseNode instanceof ErrorTypeNode)) continue;
            bl = false;
        }
        if (this.functionAuto != null) {
            bl &= this.functionAuto.checkLocal();
            bl &= this.functionAuto.checkLocal(this);
        }
        return bl;
    }

    public Function getFunction() {
        return this.checkIR(Function.class);
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return functionType;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        Function function = this.isMethod ? new FunctionMethod(this.getIdentNode().toString(), this.getIdentNode().getIdent(), this.resultType.checkIR(Type.class)) : new Function(this.getIdentNode().toString(), this.getIdentNode().getIdent(), this.resultType.checkIR(Type.class));
        this.setIR(function);
        for (DeclNode baseNode : this.parameters.getChildren()) {
            function.addParameter(baseNode.checkIR(Entity.class));
        }
        if (this.functionAuto != null) {
            this.functionAuto.getStatements(this, function);
        } else {
            for (EvalStatementNode evalStatementNode : this.evalStatements.getChildren()) {
                function.addStatement(evalStatementNode.checkIR(EvalStatement.class));
            }
        }
        return function;
    }

    public static String getKindStr() {
        return "function";
    }

    static {
        FunctionDeclNode.setName(FunctionDeclNode.class, "function declaration");
        functionType = new FunctionTypeNode();
    }
}

