/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.decl.executable;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.FilterCharacter;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ActionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationPairResolver;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.FilterAutoGenerated;
import de.unika.ipd.grgen.ir.executable.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class FilterAutoGeneratedDeclNode
extends FilterAutoDeclNode
implements FilterCharacter {
    protected String name;
    protected ArrayList<String> entities;
    protected ArrayList<TypeNode> entityTypes;
    protected IdentNode actionUnresolved;
    protected ActionDeclNode action;
    protected IteratedDeclNode iterated;
    private static final DeclarationPairResolver<ActionDeclNode, IteratedDeclNode> actionOrIteratedResolver;

    public FilterAutoGeneratedDeclNode(IdentNode identNode, String string, ArrayList<String> arrayList, IdentNode identNode2) {
        super(identNode);
        this.name = string;
        this.entities = arrayList;
        this.actionUnresolved = identNode2;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.actionUnresolved, this.action, this.iterated));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("actionOrIterated");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        Object object = actionOrIteratedResolver.resolve(this.actionUnresolved, this);
        if (object == null) {
            return false;
        }
        this.action = (ActionDeclNode)((Pair)object).fst;
        this.iterated = (IteratedDeclNode)((Pair)object).snd;
        return this.action != null || this.iterated != null;
    }

    @Override
    protected boolean checkLocal() {
        if (this.entities == null) {
            if (!this.name.equals("auto")) {
                this.reportError("Unknown auto-generated filter " + this.name + " (only auto comes without parameters).");
                return false;
            }
            if (this.iterated != null) {
                this.reportError("The auto filter is only available for rules/tests (not iterateds).");
                return false;
            }
            return true;
        }
        this.entityTypes = new ArrayList();
        for (int i = 0; i < this.entities.size(); ++i) {
            DeclNode declNode;
            if (this.name.equals("keepOneForEachAccumulateBy") && i == this.entities.size() - 1) continue;
            String string = this.entities.get(i);
            DeclNode declNode2 = declNode = this.action != null ? this.action.pattern.tryGetMember(string) : this.iterated.pattern.tryGetMember(string);
            if (declNode == null) {
                this.reportError("The entity " + string + " referenced in the filter declaration " + this.getFilterNameWithEntitySuffix() + " is not known in the " + (this.action != null ? this.action.getKind() + " " + this.action.getIdentNode() : "iterated " + this.iterated.getIdentNode()) + ".");
                return false;
            }
            this.entityTypes.add(declNode.getDeclType());
        }
        return true;
    }

    @Override
    public String getFilterName() {
        return this.name;
    }

    public String getFilterNameWithEntitySuffix() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        if (this.entities != null && !this.entities.isEmpty()) {
            stringBuilder.append("<");
            boolean bl = true;
            for (String string : this.entities) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    @Override
    public ActionDeclNode getActionNode() {
        return this.action;
    }

    public IteratedDeclNode getIteratedNode() {
        return this.iterated;
    }

    public FilterAutoGenerated getFilterAutoGenerated() {
        return this.checkIR(FilterAutoGenerated.class);
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        FilterAutoGenerated filterAutoGenerated = new FilterAutoGenerated(this.name, this.entities);
        this.setIR(filterAutoGenerated);
        Rule rule = this.action != null ? this.action.getMatcher() : this.iterated.getMatcher();
        filterAutoGenerated.setAction(rule);
        rule.addFilter(filterAutoGenerated);
        if (this.entityTypes != null) {
            for (TypeNode typeNode : this.entityTypes) {
                filterAutoGenerated.addEntityType(typeNode.getType());
            }
        }
        return filterAutoGenerated;
    }

    public static String getKindStr() {
        return "auto generated filter";
    }

    static {
        FilterAutoGeneratedDeclNode.setName(FilterAutoGeneratedDeclNode.class, "auto generated filter");
        actionOrIteratedResolver = new DeclarationPairResolver<ActionDeclNode, IteratedDeclNode>(ActionDeclNode.class, IteratedDeclNode.class);
    }
}

