/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CallActionNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.MatchTypeQualIdentNode;
import de.unika.ipd.grgen.ast.decl.executable.MatchClassFilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ir.Bad;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MultiCallActionNode
extends BaseNode {
    private CollectNode<CallActionNode> actionCalls;
    private CollectNode<BaseNode> matchClassFilterFunctionsUnresolved;
    protected CollectNode<MatchTypeQualIdentNode> matchClassFilterFunctions;

    public MultiCallActionNode(Coords coords, CollectNode<CallActionNode> collectNode, CollectNode<BaseNode> collectNode2) {
        super(coords);
        this.actionCalls = collectNode;
        this.matchClassFilterFunctionsUnresolved = collectNode2;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.actionCalls);
        vector.add(this.getValidVersion(this.matchClassFilterFunctionsUnresolved, this.matchClassFilterFunctions));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("actionCalls");
        vector.add("matchClassFilter");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.matchClassFilterFunctions = new CollectNode();
        for (BaseNode baseNode : this.matchClassFilterFunctionsUnresolved.getChildren()) {
            this.matchClassFilterFunctions.addChild((MatchTypeQualIdentNode)baseNode);
        }
        return true;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    protected boolean checkPost() {
        boolean bl = true;
        for (MatchTypeQualIdentNode matchTypeQualIdentNode : this.matchClassFilterFunctions.getChildren()) {
            MatchClassFilterFunctionDeclNode matchClassFilterFunctionDeclNode = (MatchClassFilterFunctionDeclNode)matchTypeQualIdentNode.getMember();
            String string = matchClassFilterFunctionDeclNode.matchType.getIdentNode().toString();
            for (CallActionNode callActionNode : this.actionCalls.getChildren()) {
                MultiCallActionNode.checkWhetherCalledActionImplementsMatchClass(string, matchClassFilterFunctionDeclNode, callActionNode);
            }
        }
        return bl;
    }

    public static void checkWhetherCalledActionImplementsMatchClass(String string, MatchClassFilterFunctionDeclNode matchClassFilterFunctionDeclNode, CallActionNode callActionNode) {
        boolean bl = false;
        for (DefinedMatchTypeNode definedMatchTypeNode : callActionNode.getAction().getImplementedMatchClasses()) {
            String string2 = definedMatchTypeNode.getIdentNode().toString();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (callActionNode.getAction().getImplementedMatchClasses().isEmpty()) {
                stringBuilder.append("no match classes");
            } else {
                boolean bl2 = true;
                for (DefinedMatchTypeNode definedMatchTypeNode : callActionNode.getAction().getImplementedMatchClasses()) {
                    String string3 = definedMatchTypeNode.getTypeName();
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string3);
                }
            }
            if (matchClassFilterFunctionDeclNode != null) {
                callActionNode.reportError("The called filter function " + matchClassFilterFunctionDeclNode.toStringWithDeclarationCoords() + " is defined for match class " + string + ". The action " + callActionNode.getAction().toStringWithDeclarationCoords() + " it is applied on does not implement the match class (it implements " + stringBuilder + ").");
            } else {
                callActionNode.reportError("The multi rule query is defined to return match class " + string + ". The action " + callActionNode.getAction().toStringWithDeclarationCoords() + " called in the multi rule query does not implement the match class (it implements " + stringBuilder + ").");
            }
        }
    }

    @Override
    protected IR constructIR() {
        assert (false);
        return Bad.getBad();
    }

    static {
        MultiCallActionNode.setName(MultiCallActionNode.class, "multiple call action");
    }
}

