/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.MatchClassFilterCharacter;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.executable.MatchClassFilterAutoGeneratedDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.MatchClassFilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationPairResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ir.Bad;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MatchTypeQualIdentNode
extends BaseNode {
    protected IdentNode ownerUnresolved;
    private DefinedMatchTypeNode owner;
    protected IdentNode memberUnresolved;
    private MatchClassFilterCharacter member;
    private static final DeclarationTypeResolver<DefinedMatchTypeNode> ownerResolver;
    private static final DeclarationPairResolver<MatchClassFilterFunctionDeclNode, MatchClassFilterAutoGeneratedDeclNode> memberResolver;

    public MatchTypeQualIdentNode(Coords coords, IdentNode identNode, IdentNode identNode2) {
        super(coords);
        this.ownerUnresolved = identNode;
        this.memberUnresolved = identNode2;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.ownerUnresolved, this.owner));
        vector.add(this.getValidVersion(this.memberUnresolved, (BaseNode)((Object)this.member)));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("owner");
        vector.add("member");
        return vector;
    }

    @Override
    public String toString() {
        return this.owner.getIdentNode().toString() + "." + this.member.getFilterName();
    }

    @Override
    protected boolean resolveLocal() {
        Object object;
        boolean bl;
        if (!(this.ownerUnresolved instanceof PackageIdentNode)) {
            MatchTypeQualIdentNode.fixupDefinition(this.ownerUnresolved, this.ownerUnresolved.getScope());
        }
        boolean bl2 = true;
        this.owner = (DefinedMatchTypeNode)ownerResolver.resolve(this.ownerUnresolved, this);
        bl2 = this.owner != null && bl2;
        boolean bl3 = bl = this.owner != null && this.owner.resolve();
        if (!bl) {
            this.reportError("Left hand side " + this.ownerUnresolved + " of '.' is not a match class.");
            return false;
        }
        if (!(this.memberUnresolved instanceof PackageIdentNode) && !MatchTypeQualIdentNode.tryFixupDefinition(this.memberUnresolved, this.owner.getScope().getParent())) {
            MatchTypeQualIdentNode.fixupDefinition(this.memberUnresolved, this.memberUnresolved.getScope());
        }
        if ((object = memberResolver.resolve(this.memberUnresolved, this)) == null) {
            this.memberUnresolved.reportError("Call of unknown match class filter function " + this.memberUnresolved + " (on " + this.owner.toStringWithDeclarationCoords() + ").");
            return false;
        }
        this.member = ((Pair)object).fst != null ? (MatchClassFilterCharacter)((Pair)object).fst : (MatchClassFilterCharacter)((Pair)object).snd;
        return bl2;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    public DefinedMatchTypeNode getOwner() {
        assert (this.isResolved());
        return this.owner;
    }

    public MatchClassFilterCharacter getMember() {
        assert (this.isResolved());
        return this.member;
    }

    @Override
    protected IR constructIR() {
        assert (false);
        return Bad.getBad();
    }

    public static String getKindStr() {
        return "match class prefixed filter";
    }

    static {
        MatchTypeQualIdentNode.setName(MatchTypeQualIdentNode.class, "match type qualified identifier");
        ownerResolver = new DeclarationTypeResolver<DefinedMatchTypeNode>(DefinedMatchTypeNode.class);
        memberResolver = new DeclarationPairResolver<MatchClassFilterFunctionDeclNode, MatchClassFilterAutoGeneratedDeclNode>(MatchClassFilterFunctionDeclNode.class, MatchClassFilterAutoGeneratedDeclNode.class);
    }
}

