/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.AlternativeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.DummyNodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.SubpatternUsageDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.ExactNode;
import de.unika.ipd.grgen.ast.pattern.HomNode;
import de.unika.ipd.grgen.ast.pattern.InducedNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.pattern.SingleNodeConnNode;
import de.unika.ipd.grgen.ast.pattern.SubpatternReplNode;
import de.unika.ipd.grgen.ast.pattern.TotallyHomNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementsNode;
import de.unika.ipd.grgen.ast.type.MatchTypeActionNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.Supplier;

public class MatchClassAutoNode
extends BaseNode {
    protected String nameOfGraph;
    protected Coords coords;
    protected int modifiers;
    protected int context;
    protected CollectNode<IdentNode> matchTypesUnresolved;
    protected CollectNode<MatchTypeActionNode> matchTypes;
    CollectNode<BaseNode> connections;
    CollectNode<BaseNode> params;
    private static final CollectResolver<MatchTypeActionNode> matchTypesResolver;

    public MatchClassAutoNode(String string, Coords coords, int n, int n2, CollectNode<IdentNode> collectNode) {
        super(coords);
        this.nameOfGraph = string;
        this.modifiers = n;
        this.context = n2;
        this.matchTypesUnresolved = this.becomeParent(collectNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.matchTypesUnresolved, this.matchTypes));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("matchTypes");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        for (IdentNode identNode : this.matchTypesUnresolved.getChildren()) {
            if (identNode instanceof PackageIdentNode) continue;
            MatchClassAutoNode.fixupDefinition(identNode, identNode.getScope());
        }
        this.matchTypes = matchTypesResolver.resolve(this.matchTypesUnresolved, this);
        return this.matchTypes != null;
    }

    @Override
    protected boolean checkLocal() {
        if (this.matchTypes.getChildren().size() != 2) {
            this.reportError("The auto(match<T> | match<S>) construct is only supported on two types (given are " + this.matchTypes.getChildren().size() + ").");
            return false;
        }
        return true;
    }

    public PatternGraphLhsNode getPatternGraph() {
        this.connections = new CollectNode();
        this.params = new CollectNode();
        CollectNode<SubpatternUsageDeclNode> collectNode = new CollectNode<SubpatternUsageDeclNode>();
        CollectNode<SubpatternReplNode> collectNode2 = new CollectNode<SubpatternReplNode>();
        CollectNode<AlternativeDeclNode> collectNode3 = new CollectNode<AlternativeDeclNode>();
        CollectNode<IteratedDeclNode> collectNode4 = new CollectNode<IteratedDeclNode>();
        CollectNode<PatternGraphLhsNode> collectNode5 = new CollectNode<PatternGraphLhsNode>();
        CollectNode<PatternGraphLhsNode> collectNode6 = new CollectNode<PatternGraphLhsNode>();
        CollectNode<ExprNode> collectNode7 = new CollectNode<ExprNode>();
        CollectNode<ExprNode> collectNode8 = new CollectNode<ExprNode>();
        CollectNode<HomNode> collectNode9 = new CollectNode<HomNode>();
        CollectNode<TotallyHomNode> collectNode10 = new CollectNode<TotallyHomNode>();
        CollectNode<ExactNode> collectNode11 = new CollectNode<ExactNode>();
        CollectNode<InducedNode> collectNode12 = new CollectNode<InducedNode>();
        PatternGraphLhsNode patternGraphLhsNode = new PatternGraphLhsNode(this.nameOfGraph, this.coords, this.connections, this.params, collectNode, collectNode2, collectNode3, collectNode4, collectNode5, collectNode6, collectNode7, collectNode8, collectNode9, collectNode10, collectNode11, collectNode12, this.modifiers, this.context);
        return patternGraphLhsNode;
    }

    public boolean fillPatternGraph(PatternGraphLhsNode patternGraphLhsNode) {
        boolean bl = true;
        CollectNode<VarDeclNode> collectNode = new CollectNode<VarDeclNode>();
        CollectNode<EvalStatementsNode> collectNode2 = new CollectNode<EvalStatementsNode>();
        HashMap<String, TypeNode> hashMap = new HashMap<String, TypeNode>();
        for (MatchTypeActionNode matchTypeActionNode : this.matchTypes.getChildren()) {
            BaseNode baseNode;
            PatternGraphLhsNode patternGraphLhsNode2 = matchTypeActionNode.getAction().pattern;
            for (ConnectionCharacter connectionCharacter : patternGraphLhsNode2.getConnections()) {
                ConstraintDeclNode constraintDeclNode;
                if (connectionCharacter instanceof ConnectionNode) {
                    baseNode = (ConnectionNode)connectionCharacter;
                    constraintDeclNode = ((ConnectionNode)baseNode).getEdge();
                    String string = constraintDeclNode.getIdentNode().getSymbol().getText();
                    if (string.startsWith("$")) {
                        bl &= this.addSourceAndTargetIfNotYetAddedOrTypeCheckIfDuplicate((ConnectionNode)baseNode, hashMap, this.connections, patternGraphLhsNode);
                        continue;
                    }
                    if (!hashMap.containsKey(string)) {
                        ConnectionNode connectionNode = ((ConnectionNode)baseNode).cloneForAuto(patternGraphLhsNode);
                        this.connections.addChild(connectionNode);
                        hashMap.put(string, ((EdgeDeclNode)constraintDeclNode).getDeclType());
                        bl &= this.replaceSourceAndTargetIfAlreadyAdded((ConnectionNode)baseNode, connectionNode, hashMap, patternGraphLhsNode);
                        continue;
                    }
                    bl &= this.addSourceAndTargetIfNotYetAddedOrTypeCheckIfDuplicate((ConnectionNode)baseNode, hashMap, this.connections, patternGraphLhsNode);
                    bl &= this.isTypeMatching(constraintDeclNode, hashMap);
                    continue;
                }
                baseNode = (SingleNodeConnNode)connectionCharacter;
                constraintDeclNode = ((SingleNodeConnNode)baseNode).getNode();
                bl &= this.addIfNotYetAddedOrTypeCheckIfDuplicate(constraintDeclNode, hashMap, this.connections, () -> MatchClassAutoNode.lambda$fillPatternGraph$0((SingleNodeConnNode)baseNode, patternGraphLhsNode));
            }
            for (VarDeclNode varDeclNode : patternGraphLhsNode2.getDefVariablesToBeYieldedTo().getChildren()) {
                bl &= this.addIfNotYetAddedOrTypeCheckIfDuplicate(varDeclNode, hashMap, this.params, () -> varDeclNode.cloneForAuto(patternGraphLhsNode));
            }
            for (BaseNode baseNode2 : patternGraphLhsNode2.params.getChildren()) {
                if (!(baseNode2 instanceof VarDeclNode)) continue;
                baseNode = (VarDeclNode)baseNode2;
                bl &= this.addIfNotYetAddedOrTypeCheckIfDuplicate((DeclNode)baseNode, hashMap, this.params, () -> MatchClassAutoNode.lambda$fillPatternGraph$1((VarDeclNode)baseNode, patternGraphLhsNode));
            }
        }
        patternGraphLhsNode.addDefVariablesToBeYieldedTo(collectNode);
        patternGraphLhsNode.addYieldings(collectNode2);
        return bl;
    }

    private boolean addSourceAndTargetIfNotYetAddedOrTypeCheckIfDuplicate(ConnectionNode connectionNode, Map<String, TypeNode> map, CollectNode<BaseNode> collectNode, PatternGraphLhsNode patternGraphLhsNode) {
        NodeDeclNode nodeDeclNode;
        boolean bl = true;
        NodeDeclNode nodeDeclNode2 = connectionNode.getSrc();
        if (!(nodeDeclNode2 instanceof DummyNodeDeclNode)) {
            bl &= this.addIfNotYetAddedOrTypeCheckIfDuplicate(nodeDeclNode2, map, collectNode, () -> new SingleNodeConnNode(nodeDeclNode2.cloneForAuto(patternGraphLhsNode)));
        }
        if (!((nodeDeclNode = connectionNode.getTgt()) instanceof DummyNodeDeclNode)) {
            bl &= this.addIfNotYetAddedOrTypeCheckIfDuplicate(nodeDeclNode, map, collectNode, () -> new SingleNodeConnNode(nodeDeclNode2.cloneForAuto(patternGraphLhsNode)));
        }
        return bl;
    }

    private boolean replaceSourceAndTargetIfAlreadyAdded(ConnectionNode connectionNode, ConnectionNode connectionNode2, Map<String, TypeNode> map, PatternGraphLhsNode patternGraphLhsNode) {
        String string;
        NodeDeclNode nodeDeclNode;
        NodeDeclNode nodeDeclNode2 = connectionNode.getSrc();
        String string2 = nodeDeclNode2.getIdentNode().getSymbol().getText();
        if (map.containsKey(string2)) {
            nodeDeclNode = new DummyNodeDeclNode(nodeDeclNode2.getIdentNode(), nodeDeclNode2.getDeclType(), nodeDeclNode2.context, patternGraphLhsNode);
            connectionNode2.setSrc(nodeDeclNode);
        }
        if (map.containsKey(string = (nodeDeclNode = connectionNode.getTgt()).getIdentNode().getSymbol().getText())) {
            DummyNodeDeclNode dummyNodeDeclNode = new DummyNodeDeclNode(nodeDeclNode.getIdentNode(), nodeDeclNode.getDeclType(), nodeDeclNode.context, patternGraphLhsNode);
            connectionNode2.setTgt(dummyNodeDeclNode);
        }
        return this.isTypeMatching(nodeDeclNode2, map) & this.isTypeMatching(nodeDeclNode, map);
    }

    private boolean addIfNotYetAddedOrTypeCheckIfDuplicate(DeclNode declNode, Map<String, TypeNode> map, CollectNode<BaseNode> collectNode, Supplier<BaseNode> supplier) {
        String string = declNode.getIdentNode().getSymbol().getText();
        if (string.startsWith("$")) {
            return true;
        }
        if (!map.containsKey(string)) {
            collectNode.addChild(supplier.get());
            map.put(string, declNode.getDeclType());
            return true;
        }
        return this.isTypeMatching(declNode, map);
    }

    private boolean isTypeMatching(DeclNode declNode, Map<String, TypeNode> map) {
        String string = declNode.getIdentNode().getSymbol().getText();
        TypeNode typeNode = map.get(string);
        if (!declNode.getDeclType().isEqual(typeNode)) {
            this.reportError("Ambiguous resulting type: the entity " + string + " is declared with type " + typeNode.toStringWithDeclarationCoords() + " and with type + " + declNode.getDeclType().toStringWithDeclarationCoords() + ".");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        throw new RuntimeException("Not implemented");
    }

    private static /* synthetic */ BaseNode lambda$fillPatternGraph$0(SingleNodeConnNode singleNodeConnNode, PatternGraphLhsNode patternGraphLhsNode) {
        return singleNodeConnNode.cloneForAuto(patternGraphLhsNode);
    }

    static {
        MatchClassAutoNode.setName(MatchClassAutoNode.class, "match class auto");
        matchTypesResolver = new CollectResolver<MatchTypeActionNode>(new DeclarationTypeResolver<MatchTypeActionNode>(MatchTypeActionNode.class));
    }
}

