/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.FunctionAutoNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeActionNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.executable.Function;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.FunctionAutoKeepOneForEachAccumulateBy;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class FunctionAutoKeepOneForEachAccumulateByNode
extends FunctionAutoNode {
    private IdentNode target;
    private VarDeclNode targetVar;
    private IdentNode attribute;
    private DeclNode member;
    private IdentNode accumulationAttribute;
    private DeclNode accumulationMember;
    private String accumulationMethod;
    private static final DeclarationResolver<VarDeclNode> targetResolver;

    public FunctionAutoKeepOneForEachAccumulateByNode(Coords coords, String string, IdentNode identNode, IdentNode identNode2, String string2, IdentNode identNode3) {
        super(coords, string);
        this.attribute = identNode;
        this.accumulationAttribute = identNode2;
        this.accumulationMethod = string2;
        this.target = identNode3;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector vector = new Vector();
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    public boolean resolveLocal() {
        this.targetVar = (VarDeclNode)targetResolver.resolve(this.target, this);
        return this.targetVar != null;
    }

    @Override
    public boolean checkLocal() {
        if (!this.function.equals("keepOneForEachAccumulateBy")) {
            this.reportError("Unknown function in auto(), expected keepOneForEachAccumulateBy (e.g. keepOneForEach<foo>Accumulate<bar>By<sum>).");
            return false;
        }
        ArrayTypeNode arrayTypeNode = this.getTargetType();
        if (!(arrayTypeNode.valueType instanceof MatchTypeActionNode) && !(arrayTypeNode.valueType instanceof DefinedMatchTypeNode)) {
            this.reportError("The auto-generated function keepOneForEachAccumulateBy can only be employed on an array of match or match class types (but is employed on an array of " + arrayTypeNode.valueType.getTypeName() + ").");
            return false;
        }
        TypeNode typeNode = arrayTypeNode.valueType;
        this.member = Resolver.resolveMember(typeNode, this.attribute);
        if (this.member == null) {
            return false;
        }
        TypeNode typeNode2 = this.getTypeOfElementToBeExtracted();
        if (!typeNode2.isFilterableType()) {
            this.target.reportError("The keepOneForEach argument of the auto-generated function keepOneForEachAccumulateBy is only available for attributes of type " + TypeNode.getFilterableTypesAsString() + " (but is employed on an attribute of type " + typeNode2.getTypeName() + ").");
            return false;
        }
        this.accumulationMember = Resolver.resolveMember(typeNode, this.accumulationAttribute);
        if (this.accumulationMember == null) {
            return false;
        }
        TypeNode typeNode3 = this.getTypeOfAccumulationElementToBeExtracted();
        if (!typeNode3.isAccumulatableType()) {
            this.target.reportError("The accumulate argument of the auto-generated function keepOneForEachAccumulateBy is only available for attributes of type " + TypeNode.getAccumulatableTypesAsString() + " (but is employed on an attribute of type " + typeNode3.getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkLocal(FunctionDeclNode functionDeclNode) {
        if (!(functionDeclNode.getResultType() instanceof ArrayTypeNode)) {
            this.reportError("The result type of the function " + functionDeclNode.getIdentNode() + " employing the auto-generated function " + this.functionName() + " must be an array (but is of type " + functionDeclNode.getResultType().getTypeName() + ").");
            return false;
        }
        ArrayTypeNode arrayTypeNode = (ArrayTypeNode)functionDeclNode.getResultType();
        if (!(arrayTypeNode.getElementType() instanceof DefinedMatchTypeNode) && !(arrayTypeNode.getElementType() instanceof MatchTypeActionNode)) {
            this.reportError("The result type of the function " + functionDeclNode.getIdentNode() + " employing the auto-generated function " + this.functionName() + " must be an array<match<class T>> or array<match<T>> (but is of type " + functionDeclNode.getResultType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    public TypeNode getType() {
        return this.getTargetType();
    }

    protected ArrayTypeNode getTargetType() {
        TypeNode typeNode = this.targetVar.getDeclType();
        return (ArrayTypeNode)typeNode;
    }

    private TypeNode getTypeOfElementToBeExtracted() {
        if (this.member != null) {
            return this.member.getDeclType();
        }
        return null;
    }

    private TypeNode getTypeOfAccumulationElementToBeExtracted() {
        if (this.accumulationMember != null) {
            return this.accumulationMember.getDeclType();
        }
        return null;
    }

    @Override
    public void getStatements(FunctionDeclNode functionDeclNode, Function function) {
        Entity entity = this.member.checkIR(Entity.class);
        Variable variable = this.accumulationMember.checkIR(Variable.class);
        FunctionAutoKeepOneForEachAccumulateBy functionAutoKeepOneForEachAccumulateBy = new FunctionAutoKeepOneForEachAccumulateBy(this.targetVar.checkIR(Variable.class), entity, variable, this.accumulationMethod);
        function.addStatement(functionAutoKeepOneForEachAccumulateBy);
    }

    private String functionName() {
        return "keepOneForEach<" + this.attribute.getIdent() + ">Accumulate<" + this.accumulationAttribute.getIdent() + ">By<" + this.accumulationMethod + ">";
    }

    static {
        FunctionAutoKeepOneForEachAccumulateByNode.setName(FunctionAutoKeepOneForEachAccumulateByNode.class, "auto keep one for each accumulate by");
        targetResolver = new DeclarationResolver<VarDeclNode>(VarDeclNode.class);
    }
}

