/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.FunctionAutoNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeActionNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.executable.Function;
import de.unika.ipd.grgen.ir.expr.Constant;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.MatchAccess;
import de.unika.ipd.grgen.ir.expr.MatchInit;
import de.unika.ipd.grgen.ir.expr.Operator;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.expr.VariableExpression;
import de.unika.ipd.grgen.ir.expr.array.ArrayInit;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.Assignment;
import de.unika.ipd.grgen.ir.stmt.ConditionStatement;
import de.unika.ipd.grgen.ir.stmt.ContainerAccumulationYield;
import de.unika.ipd.grgen.ir.stmt.DefDeclVarStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.ReturnStatement;
import de.unika.ipd.grgen.ir.stmt.array.ArrayVarAddItem;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.util.Base;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;

public class FunctionAutoJoinNode
extends FunctionAutoNode {
    private String joinFunction;
    private CollectNode<VarDeclNode> arguments = new CollectNode();
    private CollectNode<IdentNode> argumentsUnresolved = new CollectNode();
    private static final CollectResolver<VarDeclNode> argumentsResolver;

    public FunctionAutoJoinNode(Coords coords, String string, String string2, CollectNode<IdentNode> collectNode) {
        super(coords, string);
        this.joinFunction = string2;
        this.argumentsUnresolved = collectNode;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.argumentsUnresolved, this.arguments));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("arguments");
        return vector;
    }

    @Override
    public boolean resolveLocal() {
        boolean bl = true;
        this.arguments = argumentsResolver.resolve(this.argumentsUnresolved, this);
        return bl;
    }

    @Override
    public boolean checkLocal() {
        DeclaredTypeNode declaredTypeNode;
        BaseNode baseNode2;
        if (!this.function.equals("join")) {
            this.reportError("Unknown function in auto(), expected join (e.g. join<natural>).");
            return false;
        }
        if (!this.joinFunction.equals("natural") && !this.joinFunction.equals("cartesian")) {
            this.reportError("Unknown join function in auto(), only natural and cartesian are supported (giving e.g. join<natural>).");
            return false;
        }
        boolean bl = true;
        if (this.arguments.getChildren().size() != 2) {
            this.reportError(this.functionName() + " must have 2 arguments.");
            bl = false;
        }
        int n = 1;
        for (BaseNode baseNode2 : this.arguments.getChildren()) {
            if (!(baseNode2.getDeclType() instanceof ArrayTypeNode)) {
                this.reportError("The " + n + ". argument to " + this.functionName() + "() must be an array.");
                bl = false;
                continue;
            }
            declaredTypeNode = (ArrayTypeNode)baseNode2.getDeclType();
            if (!(((ArrayTypeNode)declaredTypeNode).getElementType() instanceof MatchTypeActionNode) && !(((ArrayTypeNode)declaredTypeNode).getElementType() instanceof DefinedMatchTypeNode)) {
                this.reportError("The " + n + ". argument to " + this.functionName() + "() must be an array<match<T>> or array<match<class T>>.");
                bl = false;
                continue;
            }
            ++n;
        }
        VarDeclNode varDeclNode = this.arguments.getChildrenAsVector().get(0);
        baseNode2 = (ArrayTypeNode)varDeclNode.getDeclType();
        declaredTypeNode = (MatchTypeNode)((ArrayTypeNode)baseNode2).valueType;
        VarDeclNode varDeclNode2 = this.arguments.getChildrenAsVector().get(1);
        ArrayTypeNode arrayTypeNode = (ArrayTypeNode)varDeclNode2.getDeclType();
        MatchTypeNode matchTypeNode = (MatchTypeNode)arrayTypeNode.valueType;
        Set<String> set = this.getNamesOfCommonEntities((MatchTypeNode)declaredTypeNode, matchTypeNode);
        for (String string : set) {
            TypeNode typeNode;
            TypeNode typeNode2 = ((MatchTypeNode)declaredTypeNode).tryGetMember(string).getDeclType();
            if (typeNode2.isEqual(typeNode = matchTypeNode.tryGetMember(string).getDeclType())) continue;
            this.reportError("The member " + string + " must be of the same type in " + declaredTypeNode.toStringWithDeclarationCoords() + " and in " + matchTypeNode.toStringWithDeclarationCoords() + " (but is of type " + typeNode2.getTypeName() + " and " + typeNode.getTypeName() + ").");
        }
        return bl;
    }

    public Set<String> getNamesOfCommonEntities(MatchTypeNode matchTypeNode, MatchTypeNode matchTypeNode2) {
        Set<String> set = matchTypeNode.getNamesOfEntities();
        Set<String> set2 = matchTypeNode2.getNamesOfEntities();
        set.retainAll(set2);
        return set;
    }

    @Override
    public boolean checkLocal(FunctionDeclNode functionDeclNode) {
        if (!(functionDeclNode.getResultType() instanceof ArrayTypeNode)) {
            this.reportError("The result type of the function " + functionDeclNode.getIdentNode() + " employing the auto-generated function " + this.functionName() + " must be an array (but is of type " + functionDeclNode.getResultType().getTypeName() + ").");
            return false;
        }
        ArrayTypeNode arrayTypeNode = (ArrayTypeNode)functionDeclNode.getResultType();
        if (!(arrayTypeNode.getElementType() instanceof DefinedMatchTypeNode)) {
            this.reportError("The result type of the function " + functionDeclNode.getIdentNode() + " employing the auto-generated function " + this.functionName() + " must be an array<match<class T>> (but is of type " + functionDeclNode.getResultType().getTypeName() + ").");
            return false;
        }
        boolean bl = true;
        DefinedMatchTypeNode definedMatchTypeNode = (DefinedMatchTypeNode)arrayTypeNode.getElementType();
        for (DeclNode declNode : definedMatchTypeNode.getEntities()) {
            String string = declNode.getIdentNode().toString();
            TypeNode typeNode = declNode.getDeclType();
            for (VarDeclNode varDeclNode : this.arguments.getChildren()) {
                TypeNode typeNode2;
                ArrayTypeNode arrayTypeNode2 = (ArrayTypeNode)varDeclNode.getDeclType();
                MatchTypeNode matchTypeNode = (MatchTypeNode)arrayTypeNode2.getElementType();
                DeclNode declNode2 = matchTypeNode.tryGetMember(string);
                if (declNode2 == null || (typeNode2 = declNode2.getDeclType()).isEqual(typeNode)) continue;
                this.reportError("The member " + string + " must be of the same type in " + definedMatchTypeNode.toStringWithDeclarationCoords() + " and in " + matchTypeNode.toStringWithDeclarationCoords() + " (but is of type " + typeNode.getTypeName() + " and " + typeNode2.getTypeName() + ").");
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void getStatements(FunctionDeclNode functionDeclNode, Function function) {
        Assignment assignment;
        Qualification qualification;
        Qualification qualification2;
        Object object;
        IR iR;
        Object object2;
        Object object3;
        IR iR2;
        Base base;
        IR iR3;
        Object object5 = function;
        ArrayTypeNode arrayTypeNode = (ArrayTypeNode)functionDeclNode.resultType;
        DefinedMatchTypeNode definedMatchTypeNode = (DefinedMatchTypeNode)arrayTypeNode.getElementType();
        Ident ident = new Ident("res", this.getCoords());
        ArrayType arrayType = (ArrayType)function.getReturnType();
        PatternGraphLhs patternGraphLhs = PatternGraphLhsNode.getInvalid().checkIR(PatternGraphLhs.class);
        Variable variable = new Variable("res", ident, arrayType, true, patternGraphLhs, 0, false);
        ArrayInit arrayInit = new ArrayInit(new Vector<Expression>(), null, arrayType, true);
        variable.setInitialization(arrayInit);
        DefDeclVarStatement defDeclVarStatement = new DefDeclVarStatement(variable);
        object5.addStatement(defDeclVarStatement);
        VarDeclNode varDeclNode = this.arguments.getChildrenAsVector().get(0);
        String string = "$match_" + varDeclNode.getIdentNode().toString();
        Ident ident2 = new Ident(string, this.getCoords());
        ArrayTypeNode arrayTypeNode2 = (ArrayTypeNode)varDeclNode.getDeclType();
        MatchTypeNode matchTypeNode = (MatchTypeNode)arrayTypeNode2.valueType;
        Type type = matchTypeNode.checkIR(Type.class);
        Variable variable2 = new Variable(string, ident2, type, true, patternGraphLhs, 0, false);
        ContainerAccumulationYield containerAccumulationYield = new ContainerAccumulationYield(variable2, null, varDeclNode.checkIR(Variable.class));
        object5.addStatement(containerAccumulationYield);
        object5 = containerAccumulationYield;
        VarDeclNode varDeclNode2 = this.arguments.getChildrenAsVector().get(1);
        String string2 = "$match_" + varDeclNode2.getIdentNode().toString();
        Ident ident3 = new Ident(string2, this.getCoords());
        ArrayTypeNode arrayTypeNode3 = (ArrayTypeNode)varDeclNode2.getDeclType();
        MatchTypeNode matchTypeNode2 = (MatchTypeNode)arrayTypeNode3.valueType;
        Type type2 = matchTypeNode2.checkIR(Type.class);
        Variable variable3 = new Variable(string2, ident3, type2, true, patternGraphLhs, 0, false);
        ContainerAccumulationYield containerAccumulationYield2 = new ContainerAccumulationYield(variable3, null, varDeclNode2.checkIR(Variable.class));
        object5.addStatement(containerAccumulationYield2);
        object5 = containerAccumulationYield2;
        Set<String> set = this.getNamesOfCommonEntities(matchTypeNode, matchTypeNode2);
        if (this.joinFunction.equals("natural")) {
            iR3 = new Constant(BasicTypeNode.booleanType.getType(), Boolean.TRUE);
            for (String object42 : set) {
                base = matchTypeNode.tryGetMember(object42);
                iR2 = base.checkIR(Entity.class);
                object3 = matchTypeNode2.tryGetMember(object42);
                Entity entity = ((BaseNode)object3).checkIR(Entity.class);
                object2 = new Operator(BasicTypeNode.booleanType.getType(), Operator.OperatorCode.EQ);
                ((Operator)object2).addOperand(new MatchAccess(new VariableExpression(variable2), (Entity)iR2));
                ((Operator)object2).addOperand(new MatchAccess(new VariableExpression(variable3), entity));
                iR = new Operator(BasicTypeNode.booleanType.getType(), Operator.OperatorCode.LOG_AND);
                ((Operator)iR).addOperand((Expression)iR3);
                ((Operator)iR).addOperand((Expression)object2);
                iR3 = iR;
            }
            object = new ConditionStatement((Expression)iR3);
            object5.addStatement((EvalStatement)object);
            object5 = object;
        }
        iR3 = new Ident("$m", this.getCoords());
        object = (DefinedMatchType)arrayType.getValueType();
        Variable variable4 = new Variable("$m", (Ident)iR3, (Type)object, true, patternGraphLhs, 0, false);
        base = new MatchInit((DefinedMatchType)object);
        variable4.setInitialization((Expression)base);
        iR2 = new DefDeclVarStatement(variable4);
        object5.addStatement((EvalStatement)iR2);
        for (DeclNode declNode : matchTypeNode.getEntities()) {
            object2 = declNode.getIdentNode().toString();
            if (((String)object2).startsWith("$") || definedMatchTypeNode.tryGetMember((String)object2) == null) continue;
            iR = ((DefinedMatchType)object).getPatternGraph().tryGetMember((String)object2);
            qualification2 = new Qualification(variable4, (Entity)iR);
            qualification = new Qualification(variable2, declNode.checkIR(Entity.class));
            assignment = new Assignment(qualification2, qualification);
            object5.addStatement(assignment);
        }
        for (DeclNode declNode : matchTypeNode2.getEntities()) {
            object2 = declNode.getIdentNode().toString();
            if (((String)object2).startsWith("$") || definedMatchTypeNode.tryGetMember((String)object2) == null || set.contains(object2)) continue;
            iR = ((DefinedMatchType)object).getPatternGraph().tryGetMember((String)object2);
            qualification2 = new Qualification(variable4, (Entity)iR);
            qualification = new Qualification(variable3, declNode.checkIR(Entity.class));
            assignment = new Assignment(qualification2, qualification);
            object5.addStatement(assignment);
        }
        object3 = new VariableExpression(variable4);
        ArrayVarAddItem arrayVarAddItem = new ArrayVarAddItem(variable, (Expression)object3, null);
        object5.addStatement(arrayVarAddItem);
        object2 = new VariableExpression(variable);
        iR = new ReturnStatement((Expression)object2);
        function.addStatement((EvalStatement)iR);
    }

    private String functionName() {
        return "join<" + this.joinFunction + ">";
    }

    static {
        FunctionAutoJoinNode.setName(FunctionAutoJoinNode.class, "function auto");
        argumentsResolver = new CollectResolver<VarDeclNode>(new DeclarationResolver<VarDeclNode>(VarDeclNode.class));
    }
}

