/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CallActionNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.MultiCallActionNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.ExecVarDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.DeclExprNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.BooleanTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ByteTypeNode;
import de.unika.ipd.grgen.ast.type.basic.DoubleTypeNode;
import de.unika.ipd.grgen.ast.type.basic.FloatTypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ast.type.basic.LongTypeNode;
import de.unika.ipd.grgen.ast.type.basic.NullTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ShortTypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ast.util.CollectQuadrupleResolver;
import de.unika.ipd.grgen.ast.util.DeclarationQuadrupleResolver;
import de.unika.ipd.grgen.ast.util.Quadruple;
import de.unika.ipd.grgen.ir.Exec;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.GraphEntityExpression;
import de.unika.ipd.grgen.ir.expr.VariableExpression;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.parser.Symbol;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public class ExecNode
extends BaseNode {
    private static final CollectQuadrupleResolver<ExecVarDeclNode, NodeDeclNode, EdgeDeclNode, VarDeclNode> graphElementUsageOutsideOfCallResolver;
    private StringBuilder sb = new StringBuilder();
    protected CollectNode<MultiCallActionNode> multiCallActions = new CollectNode();
    public CollectNode<CallActionNode> callActions = new CollectNode();
    private CollectNode<ExecVarDeclNode> varDecls = new CollectNode();
    private CollectNode<IdentNode> usageUnresolved = new CollectNode();
    private CollectNode<IdentNode> writeUsageUnresolved = new CollectNode();
    private CollectNode<DeclNode> usage = new CollectNode();
    private CollectNode<DeclNode> writeUsage = new CollectNode();
    private boolean disableXgrsStringBuilding = false;

    public ExecNode(Coords coords) {
        super(coords);
        this.becomeParent(this.multiCallActions);
        this.becomeParent(this.callActions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(Object object) {
        assert (!this.isResolved());
        if (this.disableXgrsStringBuilding) {
            return;
        }
        if (object instanceof ConstNode) {
            ConstNode constNode = (ConstNode)object;
            TypeNode typeNode = constNode.getType();
            Object object2 = constNode.getValue();
            if (typeNode instanceof StringTypeNode) {
                if (object2 == null) {
                    this.sb.append("null");
                    return;
                } else {
                    this.sb.append("\"" + object2 + "\"");
                }
                return;
            } else if (typeNode instanceof IntTypeNode || typeNode instanceof DoubleTypeNode || typeNode instanceof ByteTypeNode || typeNode instanceof ShortTypeNode) {
                this.sb.append(object2);
                return;
            } else if (typeNode instanceof FloatTypeNode) {
                this.sb.append(object2 + "f");
                return;
            } else if (typeNode instanceof LongTypeNode) {
                this.sb.append(object2 + "L");
                return;
            } else if (typeNode instanceof BooleanTypeNode) {
                this.sb.append((Boolean)object2 != false ? "true" : "false");
                return;
            } else {
                if (!(typeNode instanceof NullTypeNode)) throw new UnsupportedOperationException("unsupported type");
                this.sb.append("null");
            }
            return;
        } else if (object instanceof IdentExprNode) {
            IdentExprNode identExprNode = (IdentExprNode)object;
            this.sb.append(identExprNode.getIdent());
            return;
        } else if (object instanceof DeclExprNode) {
            DeclExprNode declExprNode = (DeclExprNode)object;
            this.sb.append(declExprNode.declUnresolved);
            return;
        } else {
            this.sb.append(object);
        }
    }

    private String getXGRSString() {
        return this.sb.toString();
    }

    public void enableXgrsStringBuilding() {
        this.disableXgrsStringBuilding = false;
    }

    public void disableXgrsStringBuilding() {
        this.disableXgrsStringBuilding = true;
    }

    public void addMultiCallAction(MultiCallActionNode multiCallActionNode) {
        assert (!this.isResolved());
        this.becomeParent(multiCallActionNode);
        this.multiCallActions.addChild(multiCallActionNode);
    }

    public void addCallAction(CallActionNode callActionNode) {
        assert (!this.isResolved());
        this.becomeParent(callActionNode);
        this.callActions.addChild(callActionNode);
    }

    public void addVarDecl(ExecVarDeclNode execVarDeclNode) {
        assert (!this.isResolved());
        this.becomeParent(execVarDeclNode);
        this.varDecls.addChild(execVarDeclNode);
    }

    public void addUsage(IdentNode identNode) {
        assert (!this.isResolved());
        this.becomeParent(identNode);
        this.usageUnresolved.addChild(identNode);
    }

    public void addWriteUsage(IdentNode identNode) {
        assert (!this.isResolved());
        this.becomeParent(identNode);
        this.writeUsageUnresolved.addChild(identNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<CollectNode<BaseNode>> vector = new Vector<CollectNode<BaseNode>>();
        vector.add(this.multiCallActions);
        vector.add(this.callActions);
        vector.add(this.varDecls);
        vector.add(this.getValidVersion(this.usageUnresolved, this.usage));
        vector.add(this.getValidVersion(this.writeUsageUnresolved, this.writeUsage));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("multi call actions");
        vector.add("call actions");
        vector.add("var decls");
        vector.add("graph element usage outside of a call");
        vector.add("writing graph element usage (outside of a call)");
        return vector;
    }

    public void addImplicitDefinitions() {
        ExecVarDeclNode execVarDeclNode;
        Symbol.Definition definition;
        Symbol.Definition definition2;
        for (IdentNode identNode : this.usageUnresolved.getChildren()) {
            debug.report(4, "Implicit definition for " + identNode + " in scope " + this.getScope());
            definition2 = this.getScope().getCurrDef(identNode.getSymbol());
            debug.report(4, "definition is: " + definition2);
            if (definition2.isValid()) {
                identNode.setSymDef(definition2);
                continue;
            }
            definition = this.getScope().define(identNode.getSymbol(), identNode.getCoords());
            identNode.setSymDef(definition);
            definition.setNode(identNode);
            this.getScope().leaveScope();
            execVarDeclNode = new ExecVarDeclNode(identNode, BasicTypeNode.untypedType);
            identNode.setDecl(execVarDeclNode);
            this.addVarDecl(execVarDeclNode);
        }
        for (IdentNode identNode : this.writeUsageUnresolved.getChildren()) {
            debug.report(4, "Implicit definition for " + identNode + " in scope " + this.getScope());
            definition2 = this.getScope().getCurrDef(identNode.getSymbol());
            debug.report(4, "definition is: " + definition2);
            if (definition2.isValid()) {
                identNode.setSymDef(definition2);
                continue;
            }
            definition = this.getScope().define(identNode.getSymbol(), identNode.getCoords());
            identNode.setSymDef(definition);
            definition.setNode(identNode);
            this.getScope().leaveScope();
            execVarDeclNode = new ExecVarDeclNode(identNode, BasicTypeNode.untypedType);
            identNode.setDecl(execVarDeclNode);
            this.addVarDecl(execVarDeclNode);
        }
    }

    @Override
    protected boolean resolveLocal() {
        Iterator iterator;
        this.addImplicitDefinitions();
        Quadruple<CollectNode<ExecVarDeclNode>, CollectNode<NodeDeclNode>, CollectNode<EdgeDeclNode>, CollectNode<VarDeclNode>> quadruple = graphElementUsageOutsideOfCallResolver.resolve(this.usageUnresolved);
        if (quadruple != null) {
            Iterator iterator2;
            if (quadruple.first != null) {
                iterator = ((CollectNode)quadruple.first).getChildren().iterator();
                while (iterator.hasNext()) {
                    iterator2 = (ExecVarDeclNode)iterator.next();
                    this.usage.addChild((DeclNode)((Object)iterator2));
                }
            }
            if (quadruple.second != null) {
                iterator = ((CollectNode)quadruple.second).getChildren().iterator();
                while (iterator.hasNext()) {
                    iterator2 = (NodeDeclNode)iterator.next();
                    this.usage.addChild((DeclNode)((Object)iterator2));
                }
            }
            if (quadruple.third != null) {
                iterator = ((CollectNode)quadruple.third).getChildren().iterator();
                while (iterator.hasNext()) {
                    iterator2 = (EdgeDeclNode)iterator.next();
                    this.usage.addChild((DeclNode)((Object)iterator2));
                }
            }
            if (quadruple.fourth != null) {
                iterator = ((CollectNode)quadruple.fourth).getChildren().iterator();
                while (iterator.hasNext()) {
                    iterator2 = (VarDeclNode)iterator.next();
                    this.usage.addChild((DeclNode)((Object)iterator2));
                }
            }
            this.becomeParent(this.usage);
        }
        if ((iterator = graphElementUsageOutsideOfCallResolver.resolve(this.writeUsageUnresolved)) != null) {
            if (((Quadruple)((Object)iterator)).first != null) {
                for (DeclNode declNode : ((CollectNode)((Quadruple)((Object)iterator)).first).getChildren()) {
                    this.writeUsage.addChild(declNode);
                }
            }
            if (((Quadruple)((Object)iterator)).second != null) {
                for (DeclNode declNode : ((CollectNode)((Quadruple)((Object)iterator)).second).getChildren()) {
                    if (!((NodeDeclNode)declNode).defEntityToBeYieldedTo) {
                        this.reportError("Only a def (to be yielded to) node is allowed to be written from an exec statement (this does not hold for " + declNode.getIdentNode() + ").");
                    }
                    this.writeUsage.addChild(declNode);
                }
            }
            if (((Quadruple)((Object)iterator)).third != null) {
                for (DeclNode declNode : ((CollectNode)((Quadruple)((Object)iterator)).third).getChildren()) {
                    if (!((EdgeDeclNode)declNode).defEntityToBeYieldedTo) {
                        this.reportError("Only a def (to be yielded to) edge is allowed to be written from an exec statement (this does not hold for " + declNode.getIdentNode() + ").");
                    }
                    this.writeUsage.addChild(declNode);
                }
            }
            if (((Quadruple)((Object)iterator)).fourth != null) {
                for (DeclNode declNode : ((CollectNode)((Quadruple)((Object)iterator)).fourth).getChildren()) {
                    if (!((VarDeclNode)declNode).defEntityToBeYieldedTo) {
                        this.reportError("Only a def (to be yielded to) variable is allowed to be written from an exec statement (this does not hold for " + declNode.getIdentNode() + ").");
                    }
                    this.writeUsage.addChild(declNode);
                }
            }
            this.becomeParent(this.writeUsage);
        }
        return quadruple != null && iterator != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public Color getNodeColor() {
        return Color.PINK;
    }

    @Override
    protected IR constructIR() {
        LinkedHashSet<Expression> linkedHashSet = new LinkedHashSet<Expression>();
        for (DeclNode baseNode : this.usage.getChildren()) {
            if (baseNode instanceof ConstraintDeclNode) {
                linkedHashSet.add(new GraphEntityExpression(baseNode.checkIR(GraphEntity.class)));
                continue;
            }
            if (!(baseNode instanceof VarDeclNode)) continue;
            linkedHashSet.add(new VariableExpression(baseNode.checkIR(Variable.class)));
        }
        for (DeclNode declNode : this.writeUsage.getChildren()) {
            if (declNode instanceof ConstraintDeclNode) {
                linkedHashSet.add(new GraphEntityExpression(declNode.checkIR(GraphEntity.class)));
                continue;
            }
            if (!(declNode instanceof VarDeclNode)) continue;
            linkedHashSet.add(new VariableExpression(declNode.checkIR(Variable.class)));
        }
        for (CallActionNode callActionNode : this.callActions.getChildren()) {
            callActionNode.checkPost();
            for (ExprNode exprNode : callActionNode.getParams().getChildren()) {
                exprNode = exprNode.evaluate();
                linkedHashSet.add(exprNode.checkIR(Expression.class));
            }
        }
        for (MultiCallActionNode multiCallActionNode : this.multiCallActions.getChildren()) {
            multiCallActionNode.checkPost();
        }
        Exec exec = new Exec(this.getXGRSString(), linkedHashSet, this.getCoords().getLine());
        return exec;
    }

    static {
        ExecNode.setName(ExecNode.class, "exec");
        graphElementUsageOutsideOfCallResolver = new CollectQuadrupleResolver(new DeclarationQuadrupleResolver<ExecVarDeclNode, NodeDeclNode, EdgeDeclNode, VarDeclNode>(ExecVarDeclNode.class, NodeDeclNode.class, EdgeDeclNode.class, VarDeclNode.class));
    }
}

